# ECS module input vars
variable "environment" {
  description = "Keep envs separate"
}

variable "app_image" {
  description = "Docker Clock image to run in ECS"
}

variable "app_count" {
  description = "Number of docker containers to run"
}

variable "task_memory" {
  description = "Docker instance memory to provision (in MiB)"
}

variable "task_cpu" {
  description = "Docker instance CPU units to provision (1 vCPU = 1024 CPU units)"
}

variable "cluster_size" {
  type = "map"

  default = {
    min     = 1
    max     = 2
    desired = 1
  }
}

variable "ec2_instance_type" {
  description = "Type of EC2 instance used in the ECS Cluster running the Clock app"
  default     = "c5.large"
}

variable "dns_servers" {
  description = "DNS servers for resolving the twitch.tv and justin.tv zones"
  type        = "list"

  default = ["10.202.125.133", "10.202.124.213", "10.202.126.110", "10.202.124.10"]
}

variable "target_group_id" {
  description = "If specified, the task will join this target group instead of its own load balancer's target group"
  default     = ""
}
