variable "ec2_instance_type" {
  description = "Type of EC2 instance"
}

variable "cluster_size" {
  description = "the min, max, and desired # of clock instances to run"
  type        = "map"
}

variable "task_memory" {
  description = "Docker instance memory to provision (in MiB)"
}

variable "task_cpu" {
  description = "Docker instance CPU units to provision (1 vCPU = 1024 CPU units)"
}

variable "app_count" {
  description = "Number of docker containers to run"
}

variable "dns_servers" {
  description = "DNS servers for resolving the twitch.tv and justin.tv zones"
  type        = "list"
  default     = ["10.202.125.133", "10.202.124.213", "10.202.126.110", "10.202.124.10"]
}

variable "ecs_host_iam_id" {
  description = "ID of IAM role for the ECS Host. Should be created by the external create_account module"
}

variable "ssh_sudoer_ldap_group" {
  description = "Members of this LDAP group may sudo when ssh'd to the EC2's"
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS Service"
}

variable "cluster_name" {
  description = "The name of this ECS cluster"
}

variable "environment" {
  description = "Keep envs separate"
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG"
}

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "30m"
}

variable "app_name" {
  description = "The basic app name, used with environment to create alarms"
}

variable "app_port" {
  description = "Port exposed by the docker image to redirect traffic to"
  default     = 8000
}

variable "debug_port" {
  description = "Port that serves debug traffic like healthchecks, pprof, and configuration introspection"
  default     = 6000
}

variable "region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "app_image" {
  description = "Docker Clock image to run in the ECS cluster"
}

variable "team_name" {
  description = "The name of the team owning these resources"
  default     = "edge-notifications"
}

variable "target_group_id" {
  description = "If specified, the task will join this target group instead of its own load balancer's target group"
  default     = ""
}

variable "lb_slow_start_seconds" {
  default = 0

  description = <<EOD
  The time period during which the load balancer sends a newly registered target
  a linearly increasing share of the traffic to the target group.
  The range is 30-900 seconds. The default is 0 seconds (disabled).
EOD
}

variable "app_log_retention_days" {
  description = "The number of days to log events"
  default     = 7
}
