module "twitch_networking" {
  source = "../twitch_networking"
  environment = var.environment
}

resource "aws_vpc_endpoint" "ldap_uw2_service" {
  vpc_id              = "${module.twitch_networking.vpc_id}"
  vpc_endpoint_type   = "Interface"
  service_name        = "${var.vpc_endpoint_service}"
  subnet_ids          = module.twitch_networking.private_subnets
  security_group_ids  = ["${module.twitch_networking.twitch_subnets_sg_id}"]
  private_dns_enabled = false
}
