# The Systems team sets up standard Twitch Networking for every account.
# This module reads those settings from that S3 bucket in our account
# Requires us-west-2 region - hardcoded in the 'outputs.tf' field names

locals {
  region = "us-west-2"
}

provider "aws" {
  version = "~> 2.0"
  region  = local.region
}

data "aws_iam_account_alias" "current" {
}

data "aws_caller_identity" "current" {
}

locals {
  acct        = data.aws_iam_account_alias.current.account_alias
  acct_suffix = element(split("-", local.acct), 2)
  staging_key = "tfstate/systems/vpc-terraform/${local.acct_suffix}/${local.acct}/terraform.tfstate"
  prod_key    = "tfstate/systems/terraform/aws/${local.acct}/terraform.tfstate"
}

# This is set up differently in the staging and prod accounts for some reason. Use the appropriate key for 
# the corresponding account when running tf. 
data "terraform_remote_state" "twitch_account" {
  backend = "s3"

  config = {
    bucket = local.acct
    key    = var.environment == "staging" ? local.staging_key : local.prod_key
    region = local.region
  }
}

