module "twitch_networking" {
  source      = "../twitch_networking"
  environment = var.environment
}

resource "aws_vpc_endpoint" "endpoint" {
  vpc_id             = module.twitch_networking.vpc_id
  vpc_endpoint_type  = "Interface"
  service_name       = var.vpc_endpoint_service
  subnet_ids         = module.twitch_networking.private_subnets
  security_group_ids = [module.twitch_networking.twitch_subnets_sg_id]
}

resource "aws_route53_zone" "zone" {
  name = var.endpoint_alias
  vpc {
    vpc_id = var.vpc_id
  }
}

resource "aws_route53_record" "alias_record" {
  zone_id = aws_route53_zone.zone.zone_id
  name    = var.endpoint_alias
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.endpoint.dns_entry[0].dns_name
    zone_id                = aws_vpc_endpoint.endpoint.dns_entry[0].hosted_zone_id
    evaluate_target_health = false
  }
}


