module "twitch_networking" {
  source      = "../twitch_networking"
  environment = "${var.environment}"
}

resource "aws_route53_resolver_endpoint" "vpc_outbound_dns" {
  name               = "vpc_outbound_dns"
  direction          = "OUTBOUND"
  security_group_ids = [module.twitch_networking.twitch_subnets_sg_id]

  ip_address {
    subnet_id = module.twitch_networking.private_subnets[0]
  }

  ip_address {
    subnet_id = module.twitch_networking.private_subnets[1]
  }

  ip_address {
    subnet_id = module.twitch_networking.private_subnets[2]
  }
}

resource "aws_route53_resolver_rule" "forward_justin_tv" {
  name                 = "forward_justin_tv_dns_cache"
  domain_name          = "justin.tv"
  rule_type            = "FORWARD"
  resolver_endpoint_id = aws_route53_resolver_endpoint.vpc_outbound_dns.id

  target_ip {
    ip = var.dns_servers[0]
  }

  target_ip {
    ip = var.dns_servers[1]
  }

  target_ip {
    ip = var.dns_servers[2]
  }

  target_ip {
    ip = var.dns_servers[3]
  }
}

resource "aws_route53_resolver_rule_association" "forward_justin_tv_association" {
  resolver_rule_id = aws_route53_resolver_rule.forward_justin_tv.id
  vpc_id           = module.twitch_networking.vpc_id
}

resource "aws_route53_resolver_rule" "forward_twitch_tv" {
  name                 = "forward_twitch_tv_dns_cache"
  domain_name          = "us-west2.twitch.tv"
  rule_type            = "FORWARD"
  resolver_endpoint_id = aws_route53_resolver_endpoint.vpc_outbound_dns.id

  target_ip {
    ip = var.dns_servers[0]
  }

  target_ip {
    ip = var.dns_servers[1]
  }

  target_ip {
    ip = var.dns_servers[2]
  }

  target_ip {
    ip = var.dns_servers[3]
  }
}

resource "aws_route53_resolver_rule_association" "forward_twitch_tv_association" {
  resolver_rule_id = aws_route53_resolver_rule.forward_twitch_tv.id
  vpc_id           = module.twitch_networking.vpc_id
}

resource "aws_vpc_dhcp_options" "dhcp" {
  domain_name         = "us-west-2.compute.internal"
  domain_name_servers = ["AmazonProvidedDNS"]
  ntp_servers         = ["169.254.169.123"]

  tags = map("Name", "${var.environment == "staging" ? "twitch-clock-dev" : "twitch-clock-prod"}-new")
}

resource "aws_vpc_dhcp_options_association" "vpc_resolver" {
  vpc_id          = module.twitch_networking.vpc_id
  dhcp_options_id = aws_vpc_dhcp_options.dhcp.id
}
