# Controlplane

Event Bus Wiring, configuration and event discovery

## Admin Operations

For admin operations, such as granting publisher authorization to services, use the [admin-cli](https://git-aws.internal.justin.tv/eventbus/admin-cli).

## Database Operations

All of the following operations require first SSHing into any EC2 instance in the desired AWS account. This EC2 instance is used as a [jump server](https://en.wikipedia.org/wiki/Jump_server) to access the database servers.

    TC=twitch-eventbus-{prod,dev}-uswest2 ssh <ec2_ip_address>

### Snapshots

Before performing any database changes, first create a snapshot of the database. To do this:

1. Via Isengard, log into the AWS account that contains the database
1. Go to the RDS dashboard
1. Select the "Databases" tab on the left, then select the database (e.g. eventbus-staging)
1. Select the "Maintenance & backups" tab, then click the "Take snapshot" button
1. Give the snapshot a name, then click "Take Snapshot"
1. Select the "Snapshots" tab on the left, then the "Manual" tab
1. Wait for the status of your snapshot to be "available"

### PostgreSQL

To access the database, we will need to determine the database's URL, which is available in the RDS section of the AWS console. Be sure to get the URL of the "writer" instance and not a "reader" instance. Then run:

    sudo docker run -it --rm postgres:10 psql -U twitch -h <database_url> eventbus

### Migrations

#### Local

To run migrations locally, you'll want to first have the `postgres-db` container running via dokcer-compose.

    make build-postgres

You can run the migrations locally using

    make local-postgres-migration

Finally, ensure that you can connect to the local `eventbus` database via the postgres shell

    make psql-shell

#### Remote

Running migrations remotely is a little more tricky. Since our EC2 instances are no longer accessible from the Twitch or Amazon
networks, we must transfer our migration files over via Bastion to a remote instance that can talk to our RDS cluster (similar to accessing the database as explained above)

This script will copy the files over to an SSH host and then run the migrations in a remote docker:

    scripts/aws-db-migrate.sh <staging|production> [<migrate args>]

When you run the script the first time, it will advise you of env vars that are needed and how to fill out the config file defaults.

Note that in order to access the password for migration, you must be a part of the eventbus ldap group. It can be viewed in the [sandstorm console](https://dashboard.internal.justin.tv/sandstorm/manage-secrets) under `eventbus/controlplane/{staging,production}/postgres_master_password`.

## Instance Level SSH

_05/11/2020_ In the most recent deployment of up-to-date Amazon Linux 2 instances to the ECS cluster, LDAP integration broke such that root access is denied on LDAP authenticated sessions. To get around this, use AWS SSM when logging directly into cluster instances:

    `aws ssm start-session --target <instance_id>`

Your environment should include Isengard Admin credentials for the AWS account the target instance belongs to. An SSM plugin is required for use with SSH. Use `brew cask install session-manager-plugin` on MacOS.

At time of writing, the alternative solution is to fork, debug, and maintain one of the most complicated terraform modules in `twitch/terraform` which is not worth the time given the above simple solution. All above documentated scripts involving the use of jump hosts still function as intended, as those jump hosts are not members of the service's ECS cluster and their LDAP integration is still functioning properly.