package main

import (
	"context"
	"encoding/json"
	"flag"
	"io/ioutil"
	"log"

	"code.justin.tv/eventbus/controlplane/cmd/controlplane-updater-lambda/handler"
	rpcinfra "code.justin.tv/eventbus/controlplane/infrastructure/rpc"
)

func main() {
	filePtr := flag.String("metadata-path", "", "path to event definition metadata json file")
	flag.Parse()
	filepath := *filePtr
	if filepath == "" {
		log.Fatal("must provide -metadata-path")
	}

	log.Println("Invoking controlplane-updater lambda locally")
	metadataBytes, err := ioutil.ReadFile(filepath)
	if err != nil {
		log.Fatal(err)
	}

	var metadata rpcinfra.EventDefinition
	err = json.Unmarshal(metadataBytes, &metadata)
	if err != nil {
		log.Fatal(err)
	}

	response, err := handler.RegisterEvent(context.Background(), metadata)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Success! Response: %s\n", string(response))
}
