package main

import (
	"fmt"
	"log"
	"time"

	pagerduty "github.com/PagerDuty/go-pagerduty"
	"github.com/davecgh/go-spew/spew"
)

const dedupKey = "this-is-my-dedup-key"

func main() {
	fmt.Println("PagerDuty test")

	//trigger
	resp, err := pagerduty.ManageEvent(pagerduty.V2Event{
		RoutingKey: "3251bf64ed084c118e556793c69ae583",
		Action:     "trigger",
		DedupKey:   dedupKey,
		Payload: &pagerduty.V2Payload{
			Summary:  "this is a test alert",
			Source:   "eventbus-validator",
			Severity: "error",
		},
	})
	if err != nil {
		log.Fatal("something bad happened", err)
	}

	spew.Dump(resp)

	time.Sleep(2 * time.Minute)

	//retrigger
	resp, err = pagerduty.ManageEvent(pagerduty.V2Event{
		RoutingKey: "3251bf64ed084c118e556793c69ae583",
		Action:     "trigger",
		DedupKey:   dedupKey,
		Payload: &pagerduty.V2Payload{
			Summary:  "this is a test alert",
			Source:   "eventbus-validator",
			Severity: "error",
		},
	})
	if err != nil {
		log.Fatal("something bad happened", err)
	}

	spew.Dump(resp)

	time.Sleep(2 * time.Minute)

	//resolve
	resp, err = pagerduty.ManageEvent(pagerduty.V2Event{
		RoutingKey: "3251bf64ed084c118e556793c69ae583",
		Action:     "resolve",
		DedupKey:   dedupKey,
	})
	if err != nil {
		log.Fatal("something bad happened", err)
	}

	spew.Dump(resp)
}
