package e2eutil

import "context"

type key string

var suiteNameKey = key("suite-name")
var jobIDKey = key("job-id")
var testPathKey = key("test-path")
var phaseKey = key("phase")

func WithSuiteName(ctx context.Context, suiteName string) context.Context {
	return context.WithValue(ctx, suiteNameKey, suiteName)
}

func SuiteName(ctx context.Context) string {
	suiteName, ok := ctx.Value(suiteNameKey).(string)
	if !ok {
		return ""
	}
	return suiteName
}

func WithJobID(ctx context.Context, jobID string) context.Context {
	return context.WithValue(ctx, jobIDKey, jobID)
}

func JobID(ctx context.Context) string {
	jobID, ok := ctx.Value(jobIDKey).(string)
	if !ok {
		return ""
	}
	return jobID
}

func WithPhase(ctx context.Context, phase string) context.Context {
	return context.WithValue(ctx, phaseKey, phase)
}

func Phase(ctx context.Context) string {
	phase, ok := ctx.Value(phaseKey).(string)
	if !ok {
		return ""
	}
	return phase
}

func TestPath(ctx context.Context) string {
	testPath, ok := ctx.Value(testPathKey).(string)
	if !ok {
		return ""
	}
	return testPath
}

func AppendTestPath(ctx context.Context, testName string) context.Context {
	currentPath := TestPath(ctx)
	var appendedPath string
	if currentPath != "" {
		appendedPath = currentPath + "/"
	}
	appendedPath = appendedPath + testName
	return context.WithValue(ctx, testPathKey, appendedPath)
}
