package e2eutil

import (
	"net/http"

	"code.justin.tv/eventbus/controlplane/internal/ldap/injector"
)

func HTTPClientWithLDAP() *http.Client {
	return HTTPClientWithLDAPUserAndGroups("controlplane-updater", []string{"e2e-group1", "e2e-group2", "controlplane-updater", "team-eventbus"})
}

func HTTPClientWithLDAPUserAndGroups(user string, groups []string) *http.Client {
	ldapTransport := injector.NewLDAPHeaderInjector(user, http.DefaultTransport)
	ldapTransport = ldapTransport.WithGroups(groups)
	return &http.Client{
		Transport: ldapTransport,
	}
}
