package e2eutil

import (
	"code.justin.tv/eventbus/client/publisher"
	"code.justin.tv/eventbus/controlplane/e2e/internal/expected"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
)

type e2eRouteFetcher struct {
	jobID string
}

// FetchRouteJSON is a custom route fetcher that bypasses S3 and uses expected topic ARNs generated including the JobID.
func (r *e2eRouteFetcher) FetchRoute(env publisher.Environment, eventType string) (*publisher.Route, error) {
	return &publisher.Route{
		Arn: expected.SNSTopicARN(r.jobID, eventType, string(env)),
	}, nil
}

func PublisherWithJobID(awsConfig *aws.Config, jobID string, env publisher.Environment, eventTypes []string) (*publisher.Publisher, error) {
	fetcher := &e2eRouteFetcher{
		jobID: jobID,
	}
	config := publisher.Config{
		Session:      session.Must(session.NewSession(awsConfig)),
		Environment:  env,
		EventTypes:   eventTypes,
		RouteFetcher: fetcher,
	}
	return publisher.New(config)
}
