package expected

import (
	"errors"
	"fmt"
	"strings"

	"code.justin.tv/eventbus/controlplane/internal/e2eaccounts"
)

const numSubscriptionARNComponents = 6
const targetInSubscriptionEndpointPosition = 5
const errInvalidSubscriptionArn = "invalid subscription ARN"

var (
	snsTopicARNPrefix = fmt.Sprintf("arn:aws:sns:us-west-2:%s:eventbus", e2eaccounts.MainAccountID)
)

func SNSTopicARN(jobID, eventType, environment string) string {
	return fmt.Sprintf("%s-%s-%s-%s", snsTopicARNPrefix, environment, eventType, jobID)
}

func RootARN(awsAccountID string) string {
	return fmt.Sprintf("arn:aws:iam::%s:root", awsAccountID)
}

// Subscriptions are in the format arn:aws:sqs:us-west-2:311539646041:eventbus-e2e-subscription-target-1
func TargetFromSubscriptionEndpointARN(endpoint string) (string, error) {
	s := strings.Split(endpoint, ":")
	if len(s) != numSubscriptionARNComponents {
		return "", errors.New(errInvalidSubscriptionArn)
	}
	return s[targetInSubscriptionEndpointPosition], nil
}
