package expected

import (
	"fmt"
)

const (
	EncryptionAtRestKeyARN       = "arn:aws:kms:us-west-2:793846415324:key/76c58211-8657-4fd9-b44e-fe454c55bbaa"
	AuthorizedFieldKeyARN        = "arn:aws:kms:us-west-2:793846415324:key/34e42da5-8459-4095-8cf1-f7ae823cb7cd"
	EncryptionContextEventType   = "EventType"
	EncryptionContextEnvironment = "Environment"
	EncryptionContextMessageName = "MessageName"
	EncryptionContextFieldName   = "FieldName"
)

func SubscriberGrantName(iamRoleID int, authorizedFieldID int) string {
	return fmt.Sprintf("Subscriber/IAMRoleID:%d/AuthorizedFieldID:%d", iamRoleID, authorizedFieldID)
}

func PublisherGrantName(iamRoleID int, eventStreamID int) string {
	return fmt.Sprintf("Publisher/IAMRoleID:%d/EventStreamID:%d", iamRoleID, eventStreamID)
}

func EncryptionContext(eventType, environment, messageName, fieldName string) map[string]string {
	return map[string]string{
		EncryptionContextEventType:   eventType,
		EncryptionContextEnvironment: environment,
		EncryptionContextMessageName: messageName,
		EncryptionContextFieldName:   fieldName,
	}
}
