package expected

import (
	"strings"
)

// ServiceName generates the service name from the provided service catalog ID
// in the seed data. Since normal operation requests the service's name from ServiceCatalog,
// the E2E generates a faked service name of the form "E2E-<ServiceCatalogID>"
func ServiceName(serviceCatalogURL string) string {
	parts := strings.Split(serviceCatalogURL, "/")
	if len(parts) == 0 {
		panic("invalid service catalog URL in test seed")
	}
	return "E2E-" + parts[4]
}
