package httpserver

import (
	"context"

	"code.justin.tv/eventbus/controlplane/e2e/internal/e2eutil"
	"code.justin.tv/eventbus/controlplane/e2e/internal/expected"
	"code.justin.tv/eventbus/controlplane/rpc"
)

func EventStream(jobID, eventType, environment string) (*rpc.EventStream, error) {
	httpClient := e2eutil.HTTPClientWithLDAP()
	eventStreamClient := rpc.NewEventStreamsProtobufClient(expected.TwirpEndpoint, httpClient)
	return eventStreamClient.Get(context.Background(), &rpc.GetEventStreamReq{
		EventType:   e2eutil.Suffix(eventType, jobID),
		Environment: environment,
	})
}

func EventStreamStats(jobID, eventType, environment string) (*rpc.EventStreamStats, error) {
	httpClient := e2eutil.HTTPClientWithLDAP()
	eventStreamClient := rpc.NewEventStreamsProtobufClient(expected.TwirpEndpoint, httpClient)
	return eventStreamClient.GetStats(context.Background(), &rpc.GetEventStreamStatsReq{
		EventType:   e2eutil.Suffix(eventType, jobID),
		Environment: environment,
	})
}
