package httpserver

import (
	"context"

	"code.justin.tv/eventbus/controlplane/e2e/internal/e2eutil"
	"code.justin.tv/eventbus/controlplane/e2e/internal/expected"
	infraRPC "code.justin.tv/eventbus/controlplane/rpc"
	"github.com/pkg/errors"
)

func FeatureFlagEnabled(jobID, name string) (bool, error) {
	httpClient := e2eutil.HTTPClientWithLDAP()
	featureflagClient := infraRPC.NewFeatureFlagsProtobufClient(expected.TwirpEndpoint, httpClient)
	resp, err := featureflagClient.IsEnabled(context.Background(), &infraRPC.IsEnabledReq{
		Name: e2eutil.Suffix(name, jobID),
	})
	if err != nil {
		return false, errors.Wrap(err, "could not fetch feature flag")
	}
	return resp.GetIsEnabled(), nil
}
