package httpserver

type Option func(*Config)

func WithLDAPUser(user string) Option {
	return func(c *Config) {
		c.ldapUser = user
	}
}

func WithLDAPGroups(groups []string) Option {
	return func(c *Config) {
		c.ldapGroups = groups
	}
}
