package httpserver

import (
	"context"

	"code.justin.tv/eventbus/controlplane/e2e/internal/e2eutil"
	"code.justin.tv/eventbus/controlplane/e2e/internal/expected"
	"code.justin.tv/eventbus/controlplane/rpc"
)

func Unsubscribe(targetID string, eventType string, environment string) error {
	httpClient := e2eutil.HTTPClientWithLDAP()
	subsClient := rpc.NewSubscriptionsProtobufClient(expected.TwirpEndpoint, httpClient)
	_, err := subsClient.Delete(context.Background(), &rpc.DeleteSubscriptionReq{
		TargetId:    targetID,
		EventType:   eventType,
		Environment: environment,
	})
	return err
}
