package report

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/logger"
	"go.uber.org/zap"
)

var log *logger.Logger

func init() {
	log = logger.FromContext(context.Background())
}

func Log(msg Message) {
	//fields = append(fields, extractFieldsFromContext(ctx)...)
	log.Info(msg.Message(), zap.Object("details", msg))
}

func LogError(err Error) {
	// fields = append(fields, extractFieldsFromContext(ctx)...)
	// fields = append(fields, zap.Error(err))
	//log.Error(msg, fields...)
	log.Error(err.Message(), zap.Object("details", err), zap.Error(err.Error()))
}

func LogErrorsFatally(errs []Error) {
	if errs != nil {
		for _, err := range errs {
			LogError(err)
		}
		log.Fatal("Fatal errors encountered, better luck next time")
	}
}
