package common

import (
	"context"
	"fmt"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/publisher"
	"code.justin.tv/eventbus/controlplane/e2e/internal/e2eutil"
	"code.justin.tv/eventbus/controlplane/e2e/internal/resource"
	"code.justin.tv/eventbus/controlplane/e2e/internal/test"
	"github.com/aws/aws-sdk-go/aws"
)

var _ test.TestRunner = &ClientPublisherTest{}

type ClientPublisherTest struct {
	test.TestRunner
	AWSConfig   *aws.Config // TODO: generate this based on the accounts specified in the Publication's Service, publish 1 message from each account
	Event       eventbus.Message
	Publication *resource.Publication
}

func (t *ClientPublisherTest) TestName() string {
	return fmt.Sprintf("ClientPublisherTest{%s,%s,%s}", t.Publication.EventType, t.Publication.Environment, t.Publication.ServiceCatalogID)
}

func (t *ClientPublisherTest) Test(ctx context.Context) {
	ctx = e2eutil.AppendTestPath(ctx, t.TestName())
	t.Log(ctx, "Checking authorized publisher account can publish to event stream")

	p, err := e2eutil.PublisherWithJobID(t.AWSConfig, e2eutil.JobID(ctx), publisher.Environment(t.Publication.Environment), []string{t.Publication.EventType})
	if err != nil {
		t.Error(ctx, "Could not create eventbus publisher client", err)
		return
	}
	err = p.Publish(ctx, t.Event)
	if err != nil {
		t.Error(ctx, "Could not publish message to eventbus", err)
	}
}
