package test

import (
	"os"
	"strconv"
)

type RuntimeConfig struct {
	TestName          string
	PromptBeforeClean bool
}

func (c *RuntimeConfig) RunAll() bool {
	return c.TestName == ""
}

func (c *RuntimeConfig) ShouldRun(testName string) bool {
	return c.RunAll() || c.TestName == testName
}

// ConfigFromEnvironment determines the runtime configuration
// of the end to end test based on optional environment variables
func ConfigFromEnvironment() (*RuntimeConfig, error) {
	cfg := &RuntimeConfig{}
	var err error
	if cfg.PromptBeforeClean, err = parseBoolOpt("E2E_PROMPT_BEFORE_CLEAN", false); err != nil {
		return nil, err
	}
	cfg.TestName = os.Getenv("E2E_TEST_NAME")
	return cfg, nil
}

func parseBoolOpt(name string, defaultVal bool) (bool, error) {
	val := os.Getenv(name)
	if val == "" {
		return defaultVal, nil
	}
	return strconv.ParseBool(val)
}
