package test

import (
	"context"

	"code.justin.tv/eventbus/controlplane/e2e/internal/report"
)

// Runner represents an independent entity which can have tests run against it
// This can be as atomic as a single resource, or as large as a test suite
// seeded with many resources of different types, implementing custom logic
// Use composition to put together a test.Runner as needed
type Runner interface {
	SetupRunner
	TestRunner
	CleanRunner
}

type SetupRunner interface {
	Setup(context.Context) report.Error
}

type TestRunner interface {
	Test(context.Context)
	Error(context.Context, string, error)
	Log(context.Context, string)
	TestName() string
}

type CleanRunner interface {
	Clean(context.Context) []report.Error
}
