package mocks

import (
	"context"
	"errors"

	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/service/sqs/sqsiface"
	"github.com/stretchr/testify/mock"
)

const (
	SQSGetQueueAttributes = "sqs-get-queue-attributes"
	SQSSetQueueAttributes = "sqs-set-queue-attributes"
	SQSGetQueueURL        = "sqs-get-queue-url"
	SQSAddPermission      = "sqs-add-permission"
	SQSRemovePermission   = "sqs-remove-permission"
)

type MockSQS struct {
	mock.Mock
	sqsiface.SQSAPI
}

func NewMockSQS() *MockSQS {
	m := &MockSQS{}
	// Layout various canned error behaviors
	m.On("GetQueueAttributesWithContext", mock.MatchedBy(IsBehavior(SQSGetQueueAttributes, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	m.On("SetQueueAttributesWithContext", mock.MatchedBy(IsBehavior(SQSSetQueueAttributes, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	m.On("GetQueueUrlWithContext", mock.MatchedBy(IsBehavior(SQSGetQueueURL, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	m.On("AddPermissionWithContext", mock.MatchedBy(IsBehavior(SQSAddPermission, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	m.On("RemovePermissionWithContext", mock.MatchedBy(IsBehavior(SQSRemovePermission, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	return m
}

func (m *MockSQS) GetQueueAttributesWithContext(ctx context.Context, in *sqs.GetQueueAttributesInput, opts ...request.Option) (*sqs.GetQueueAttributesOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sqs.GetQueueAttributesOutput), args.Error(1)
}

func (m *MockSQS) SetQueueAttributesWithContext(ctx context.Context, in *sqs.SetQueueAttributesInput, opts ...request.Option) (*sqs.SetQueueAttributesOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sqs.SetQueueAttributesOutput), args.Error(1)
}

func (m *MockSQS) GetQueueUrlWithContext(ctx context.Context, in *sqs.GetQueueUrlInput, opts ...request.Option) (*sqs.GetQueueUrlOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sqs.GetQueueUrlOutput), args.Error(1)
}

func (m *MockSQS) AddPermissionWithContext(ctx context.Context, in *sqs.AddPermissionInput, opts ...request.Option) (*sqs.AddPermissionOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sqs.AddPermissionOutput), args.Error(1)
}

func (m *MockSQS) RemovePermissionWithContext(ctx context.Context, in *sqs.RemovePermissionInput, opts ...request.Option) (*sqs.RemovePermissionOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sqs.RemovePermissionOutput), args.Error(1)
}
