package mocks

import (
	"context"
	"errors"

	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sts"
	"github.com/aws/aws-sdk-go/service/sts/stsiface"
	"github.com/stretchr/testify/mock"
)

const (
	STSGetCallerIdentity = "sts-get-caller-identity"
)

type MockSTS struct {
	mock.Mock
	stsiface.STSAPI
}

func NewMockSTS() *MockSTS {
	m := &MockSTS{}
	m.On("GetCallerIdentityWithContext", mock.MatchedBy(IsBehavior(STSGetCallerIdentity, Error)), mock.Anything, mock.Anything).Return(nil, errors.New(Error))
	return m
}

func (m *MockSTS) GetCallerIdentityWithContext(ctx context.Context, in *sts.GetCallerIdentityInput, opts ...request.Option) (*sts.GetCallerIdentityOutput, error) {
	args := m.Called(ctx, in, opts)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	return args.Get(0).(*sts.GetCallerIdentityOutput), args.Error(1)
}
