package notification

import (
	"testing"

	"code.justin.tv/eventbus/controlplane/infrastructure/validation"
	"github.com/stretchr/testify/assert"
)

func TestRoutingKeyFetch(t *testing.T) {
	highKey := "high-key"
	lowKey := "low-key"
	actions := &pagerdutyActions{
		high: highKey,
		low:  lowKey,
	}

	assert.Equal(t, highKey, actions.routingKey(validation.StatusError))
	assert.Equal(t, highKey, actions.routingKey(validation.StatusValidationError))
	assert.Equal(t, lowKey, actions.routingKey(validation.StatusWarn))
	assert.Empty(t, actions.routingKey(validation.StatusOk)) // undefined behavior
}
