package routing

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/s3"
)

// whole S3 iface is 400 lines 200 methods, we only need these two to mock.
type S3Iface interface {
	GetObjectWithContext(aws.Context, *s3.GetObjectInput, ...request.Option) (*s3.GetObjectOutput, error)
	PutObjectWithContext(aws.Context, *s3.PutObjectInput, ...request.Option) (*s3.PutObjectOutput, error)
}

func S3BucketName(env string) string {
	switch env {
	case "staging":
		return "eventbus-config-testing.internal.justin.tv"
	case "production", "prod":
		return "eventbus-config.internal.justin.tv"
	case "e2e-test":
		return "eventbus-config-e2e.internal.justin.tv"
	case "local":
		return "local"
	default:
		// If no environment is set assume invalid configuration - don't overwrite any files
		return ""
	}
}
