package routing

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestS3(t *testing.T) {
	t.Run("S3BucketName", func(t *testing.T) {
		t.Run("retrieves staging bucket", func(t *testing.T) {
			bucket := S3BucketName("staging")
			assert.Equal(t, bucket, "eventbus-config-testing.internal.justin.tv")
		})
		t.Run("retrieves production bucket", func(t *testing.T) {
			bucket := S3BucketName("production")
			assert.Equal(t, bucket, "eventbus-config.internal.justin.tv")
		})
		t.Run("retrieves development bucket (not yet extant)", func(t *testing.T) {
			bucket := S3BucketName("")
			assert.Equal(t, bucket, "")
		})
		t.Run("defaults to empty", func(t *testing.T) {
			bucket := S3BucketName("")
			assert.Equal(t, bucket, "")
		})
	})
}
