// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/infrastructure/rpc/infrastructure.proto

/*
Package rpc is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	code.justin.tv/eventbus/controlplane/infrastructure/rpc/infrastructure.proto
*/
package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ========================
// Infrastructure Interface
// ========================

type Infrastructure interface {
	// AllowAccountsPublish is used by tooling to allow services to publish to an event stream
	AllowAccountsPublish(context.Context, *AllowAccountsPublishReq) (*AllowAccountsPublishResp, error)

	// AllowIAMRolePublish is used by tooling to allow an IAM role to publish to an event stream
	AllowIAMRolePublish(context.Context, *AllowIAMRolePublishReq) (*AllowIAMRolePublishResp, error)

	// RegisterEventDefinitions is used by tooling to register one or more event types into the system
	RegisterEventDefinitions(context.Context, *RegisterEventDefinitionsReq) (*RegisterEventDefinitionsResp, error)

	// CreateAuthorizedFieldSubscriberGrant is used to give a subscriber permission to access an authorized field
	CreateAuthorizedFieldSubscriberGrant(context.Context, *CreateAuthorizedFieldSubscriberGrantReq) (*CreateAuthorizedFieldSubscriberGrantResp, error)

	// CreateAuthorizedFieldPublisherGrant is used to give a publisher permission to build authorized fields
	CreateAuthorizedFieldPublisherGrant(context.Context, *CreateAuthorizedFieldPublisherGrantReq) (*CreateAuthorizedFieldPublisherGrantResp, error)

	// RevokeAuthorizedFieldGrant revokes either a publisher or a subscriber grant
	RevokeAuthorizedFieldGrant(context.Context, *RevokeAuthorizedFieldGrantReq) (*RevokeAuthorizedFieldGrantResp, error)

	// DeletePublication is used by admin cli to remove a publication to a deprecated event stream
	DeletePublication(context.Context, *DeletePublicationReq) (*DeletePublicationResp, error)

	// DeleteIAMRolePublication deletes a publication given an event type, environment, and IAM role.
	// Does the full tear down idempotently, including revoking the associated authorized field
	// publisher grant and deleting that DB record as well
	DeleteIAMRolePublication(context.Context, *DeleteIAMRolePublicationReq) (*DeleteIAMRolePublicationResp, error)

	// ListPublicationsByEventStream lists all of the publishers for a given event stream
	ListPublicationsByEventStream(context.Context, *ListPublicationsByEventStreamReq) (*ListPublicationsByEventStreamResp, error)

	// DeleteAuthorizedFieldGrant is used by admin cli to remove authorized field rows in the backend
	DeleteAuthorizedFieldGrant(context.Context, *DeleteAuthorizedFieldGrantReq) (*DeleteAuthorizedFieldGrantResp, error)

	// DeleteAuthorizedFieldSubscriberGrant revokes the KMS grant and removes the DB row idempotently
	DeleteAuthorizedFieldSubscriberGrant(context.Context, *DeleteAuthorizedFieldSubscriberGrantReq) (*DeleteAuthorizedFieldSubscriberGrantResp, error)

	// DeleteEventType removes the associated event from the backend
	DeleteEventType(context.Context, *DeleteEventTypeReq) (*DeleteEventTypeResp, error)

	// DeleteEventStreamsForEventType removes all of the event streams for the event type name
	DeleteEventStreamsForEventType(context.Context, *DeleteEventStreamsForEventTypeReq) (*DeleteEventStreamsForEventTypeResp, error)

	// DeleteAuthorizedField removes an authed field
	DeleteAuthorizedField(context.Context, *DeleteAuthorizedFieldReq) (*DeleteAuthorizedFieldResp, error)

	// ListAuthorizedFieldSubscriberGrantsByAuthorizedField lists the subscriber grants related to the given authed field
	ListAuthorizedFieldSubscriberGrantsByAuthorizedField(context.Context, *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq) (*ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, error)
}

// ==============================
// Infrastructure Protobuf Client
// ==============================

type infrastructureProtobufClient struct {
	client HTTPClient
	urls   [15]string
}

// NewInfrastructureProtobufClient creates a Protobuf client that implements the Infrastructure interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewInfrastructureProtobufClient(addr string, client HTTPClient) Infrastructure {
	prefix := urlBase(addr) + InfrastructurePathPrefix
	urls := [15]string{
		prefix + "AllowAccountsPublish",
		prefix + "AllowIAMRolePublish",
		prefix + "RegisterEventDefinitions",
		prefix + "CreateAuthorizedFieldSubscriberGrant",
		prefix + "CreateAuthorizedFieldPublisherGrant",
		prefix + "RevokeAuthorizedFieldGrant",
		prefix + "DeletePublication",
		prefix + "DeleteIAMRolePublication",
		prefix + "ListPublicationsByEventStream",
		prefix + "DeleteAuthorizedFieldGrant",
		prefix + "DeleteAuthorizedFieldSubscriberGrant",
		prefix + "DeleteEventType",
		prefix + "DeleteEventStreamsForEventType",
		prefix + "DeleteAuthorizedField",
		prefix + "ListAuthorizedFieldSubscriberGrantsByAuthorizedField",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &infrastructureProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &infrastructureProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *infrastructureProtobufClient) AllowAccountsPublish(ctx context.Context, in *AllowAccountsPublishReq) (*AllowAccountsPublishResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "AllowAccountsPublish")
	out := new(AllowAccountsPublishResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) AllowIAMRolePublish(ctx context.Context, in *AllowIAMRolePublishReq) (*AllowIAMRolePublishResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "AllowIAMRolePublish")
	out := new(AllowIAMRolePublishResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) RegisterEventDefinitions(ctx context.Context, in *RegisterEventDefinitionsReq) (*RegisterEventDefinitionsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterEventDefinitions")
	out := new(RegisterEventDefinitionsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) CreateAuthorizedFieldSubscriberGrant(ctx context.Context, in *CreateAuthorizedFieldSubscriberGrantReq) (*CreateAuthorizedFieldSubscriberGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldSubscriberGrant")
	out := new(CreateAuthorizedFieldSubscriberGrantResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) CreateAuthorizedFieldPublisherGrant(ctx context.Context, in *CreateAuthorizedFieldPublisherGrantReq) (*CreateAuthorizedFieldPublisherGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldPublisherGrant")
	out := new(CreateAuthorizedFieldPublisherGrantResp)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) RevokeAuthorizedFieldGrant(ctx context.Context, in *RevokeAuthorizedFieldGrantReq) (*RevokeAuthorizedFieldGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "RevokeAuthorizedFieldGrant")
	out := new(RevokeAuthorizedFieldGrantResp)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeletePublication(ctx context.Context, in *DeletePublicationReq) (*DeletePublicationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeletePublication")
	out := new(DeletePublicationResp)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteIAMRolePublication(ctx context.Context, in *DeleteIAMRolePublicationReq) (*DeleteIAMRolePublicationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRolePublication")
	out := new(DeleteIAMRolePublicationResp)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) ListPublicationsByEventStream(ctx context.Context, in *ListPublicationsByEventStreamReq) (*ListPublicationsByEventStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicationsByEventStream")
	out := new(ListPublicationsByEventStreamResp)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteAuthorizedFieldGrant(ctx context.Context, in *DeleteAuthorizedFieldGrantReq) (*DeleteAuthorizedFieldGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldGrant")
	out := new(DeleteAuthorizedFieldGrantResp)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteAuthorizedFieldSubscriberGrant(ctx context.Context, in *DeleteAuthorizedFieldSubscriberGrantReq) (*DeleteAuthorizedFieldSubscriberGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldSubscriberGrant")
	out := new(DeleteAuthorizedFieldSubscriberGrantResp)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteEventType(ctx context.Context, in *DeleteEventTypeReq) (*DeleteEventTypeResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventType")
	out := new(DeleteEventTypeResp)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteEventStreamsForEventType(ctx context.Context, in *DeleteEventStreamsForEventTypeReq) (*DeleteEventStreamsForEventTypeResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventStreamsForEventType")
	out := new(DeleteEventStreamsForEventTypeResp)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) DeleteAuthorizedField(ctx context.Context, in *DeleteAuthorizedFieldReq) (*DeleteAuthorizedFieldResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedField")
	out := new(DeleteAuthorizedFieldResp)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *infrastructureProtobufClient) ListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx context.Context, in *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq) (*ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "ListAuthorizedFieldSubscriberGrantsByAuthorizedField")
	out := new(ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

// ==========================
// Infrastructure JSON Client
// ==========================

type infrastructureJSONClient struct {
	client HTTPClient
	urls   [15]string
}

// NewInfrastructureJSONClient creates a JSON client that implements the Infrastructure interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewInfrastructureJSONClient(addr string, client HTTPClient) Infrastructure {
	prefix := urlBase(addr) + InfrastructurePathPrefix
	urls := [15]string{
		prefix + "AllowAccountsPublish",
		prefix + "AllowIAMRolePublish",
		prefix + "RegisterEventDefinitions",
		prefix + "CreateAuthorizedFieldSubscriberGrant",
		prefix + "CreateAuthorizedFieldPublisherGrant",
		prefix + "RevokeAuthorizedFieldGrant",
		prefix + "DeletePublication",
		prefix + "DeleteIAMRolePublication",
		prefix + "ListPublicationsByEventStream",
		prefix + "DeleteAuthorizedFieldGrant",
		prefix + "DeleteAuthorizedFieldSubscriberGrant",
		prefix + "DeleteEventType",
		prefix + "DeleteEventStreamsForEventType",
		prefix + "DeleteAuthorizedField",
		prefix + "ListAuthorizedFieldSubscriberGrantsByAuthorizedField",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &infrastructureJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &infrastructureJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *infrastructureJSONClient) AllowAccountsPublish(ctx context.Context, in *AllowAccountsPublishReq) (*AllowAccountsPublishResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "AllowAccountsPublish")
	out := new(AllowAccountsPublishResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *infrastructureJSONClient) AllowIAMRolePublish(ctx context.Context, in *AllowIAMRolePublishReq) (*AllowIAMRolePublishResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "AllowIAMRolePublish")
	out := new(AllowIAMRolePublishResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *infrastructureJSONClient) RegisterEventDefinitions(ctx context.Context, in *RegisterEventDefinitionsReq) (*RegisterEventDefinitionsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterEventDefinitions")
	out := new(RegisterEventDefinitionsResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *infrastructureJSONClient) CreateAuthorizedFieldSubscriberGrant(ctx context.Context, in *CreateAuthorizedFieldSubscriberGrantReq) (*CreateAuthorizedFieldSubscriberGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldSubscriberGrant")
	out := new(CreateAuthorizedFieldSubscriberGrantResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *infrastructureJSONClient) CreateAuthorizedFieldPublisherGrant(ctx context.Context, in *CreateAuthorizedFieldPublisherGrantReq) (*CreateAuthorizedFieldPublisherGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldPublisherGrant")
	out := new(CreateAuthorizedFieldPublisherGrantResp)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *infrastructureJSONClient) RevokeAuthorizedFieldGrant(ctx context.Context, in *RevokeAuthorizedFieldGrantReq) (*RevokeAuthorizedFieldGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "RevokeAuthorizedFieldGrant")
	out := new(RevokeAuthorizedFieldGrantResp)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeletePublication(ctx context.Context, in *DeletePublicationReq) (*DeletePublicationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeletePublication")
	out := new(DeletePublicationResp)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteIAMRolePublication(ctx context.Context, in *DeleteIAMRolePublicationReq) (*DeleteIAMRolePublicationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRolePublication")
	out := new(DeleteIAMRolePublicationResp)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *infrastructureJSONClient) ListPublicationsByEventStream(ctx context.Context, in *ListPublicationsByEventStreamReq) (*ListPublicationsByEventStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicationsByEventStream")
	out := new(ListPublicationsByEventStreamResp)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteAuthorizedFieldGrant(ctx context.Context, in *DeleteAuthorizedFieldGrantReq) (*DeleteAuthorizedFieldGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldGrant")
	out := new(DeleteAuthorizedFieldGrantResp)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteAuthorizedFieldSubscriberGrant(ctx context.Context, in *DeleteAuthorizedFieldSubscriberGrantReq) (*DeleteAuthorizedFieldSubscriberGrantResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldSubscriberGrant")
	out := new(DeleteAuthorizedFieldSubscriberGrantResp)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteEventType(ctx context.Context, in *DeleteEventTypeReq) (*DeleteEventTypeResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventType")
	out := new(DeleteEventTypeResp)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteEventStreamsForEventType(ctx context.Context, in *DeleteEventStreamsForEventTypeReq) (*DeleteEventStreamsForEventTypeResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventStreamsForEventType")
	out := new(DeleteEventStreamsForEventTypeResp)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *infrastructureJSONClient) DeleteAuthorizedField(ctx context.Context, in *DeleteAuthorizedFieldReq) (*DeleteAuthorizedFieldResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedField")
	out := new(DeleteAuthorizedFieldResp)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *infrastructureJSONClient) ListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx context.Context, in *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq) (*ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithMethodName(ctx, "ListAuthorizedFieldSubscriberGrantsByAuthorizedField")
	out := new(ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

// =============================
// Infrastructure Server Handler
// =============================

type infrastructureServer struct {
	Infrastructure
	hooks *twirp.ServerHooks
}

func NewInfrastructureServer(svc Infrastructure, hooks *twirp.ServerHooks) TwirpServer {
	return &infrastructureServer{
		Infrastructure: svc,
		hooks:          hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *infrastructureServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// InfrastructurePathPrefix is used for all URL paths on a twirp Infrastructure server.
// Requests are always: POST InfrastructurePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const InfrastructurePathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/"

func (s *infrastructureServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane.infrastructure")
	ctx = ctxsetters.WithServiceName(ctx, "Infrastructure")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/AllowAccountsPublish":
		s.serveAllowAccountsPublish(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/AllowIAMRolePublish":
		s.serveAllowIAMRolePublish(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/RegisterEventDefinitions":
		s.serveRegisterEventDefinitions(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/CreateAuthorizedFieldSubscriberGrant":
		s.serveCreateAuthorizedFieldSubscriberGrant(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/CreateAuthorizedFieldPublisherGrant":
		s.serveCreateAuthorizedFieldPublisherGrant(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/RevokeAuthorizedFieldGrant":
		s.serveRevokeAuthorizedFieldGrant(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeletePublication":
		s.serveDeletePublication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteIAMRolePublication":
		s.serveDeleteIAMRolePublication(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/ListPublicationsByEventStream":
		s.serveListPublicationsByEventStream(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteAuthorizedFieldGrant":
		s.serveDeleteAuthorizedFieldGrant(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteAuthorizedFieldSubscriberGrant":
		s.serveDeleteAuthorizedFieldSubscriberGrant(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteEventType":
		s.serveDeleteEventType(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteEventStreamsForEventType":
		s.serveDeleteEventStreamsForEventType(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/DeleteAuthorizedField":
		s.serveDeleteAuthorizedField(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/ListAuthorizedFieldSubscriberGrantsByAuthorizedField":
		s.serveListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *infrastructureServer) serveAllowAccountsPublish(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllowAccountsPublishJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllowAccountsPublishProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveAllowAccountsPublishJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllowAccountsPublish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllowAccountsPublishReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowAccountsPublishResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowAccountsPublish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowAccountsPublishResp and nil error while calling AllowAccountsPublish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveAllowAccountsPublishProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllowAccountsPublish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AllowAccountsPublishReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowAccountsPublishResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowAccountsPublish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowAccountsPublishResp and nil error while calling AllowAccountsPublish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveAllowIAMRolePublish(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllowIAMRolePublishJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllowIAMRolePublishProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveAllowIAMRolePublishJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllowIAMRolePublish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllowIAMRolePublishReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowIAMRolePublishResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowIAMRolePublish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowIAMRolePublishResp and nil error while calling AllowIAMRolePublish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveAllowIAMRolePublishProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllowIAMRolePublish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AllowIAMRolePublishReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowIAMRolePublishResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowIAMRolePublish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowIAMRolePublishResp and nil error while calling AllowIAMRolePublish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveRegisterEventDefinitions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterEventDefinitionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterEventDefinitionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveRegisterEventDefinitionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterEventDefinitions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterEventDefinitionsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterEventDefinitionsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterEventDefinitions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterEventDefinitionsResp and nil error while calling RegisterEventDefinitions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveRegisterEventDefinitionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterEventDefinitions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RegisterEventDefinitionsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterEventDefinitionsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterEventDefinitions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterEventDefinitionsResp and nil error while calling RegisterEventDefinitions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveCreateAuthorizedFieldSubscriberGrant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAuthorizedFieldSubscriberGrantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAuthorizedFieldSubscriberGrantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveCreateAuthorizedFieldSubscriberGrantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldSubscriberGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAuthorizedFieldSubscriberGrantReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAuthorizedFieldSubscriberGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAuthorizedFieldSubscriberGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAuthorizedFieldSubscriberGrantResp and nil error while calling CreateAuthorizedFieldSubscriberGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveCreateAuthorizedFieldSubscriberGrantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldSubscriberGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateAuthorizedFieldSubscriberGrantReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAuthorizedFieldSubscriberGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAuthorizedFieldSubscriberGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAuthorizedFieldSubscriberGrantResp and nil error while calling CreateAuthorizedFieldSubscriberGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveCreateAuthorizedFieldPublisherGrant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAuthorizedFieldPublisherGrantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAuthorizedFieldPublisherGrantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveCreateAuthorizedFieldPublisherGrantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldPublisherGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAuthorizedFieldPublisherGrantReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAuthorizedFieldPublisherGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAuthorizedFieldPublisherGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAuthorizedFieldPublisherGrantResp and nil error while calling CreateAuthorizedFieldPublisherGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveCreateAuthorizedFieldPublisherGrantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAuthorizedFieldPublisherGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateAuthorizedFieldPublisherGrantReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAuthorizedFieldPublisherGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAuthorizedFieldPublisherGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAuthorizedFieldPublisherGrantResp and nil error while calling CreateAuthorizedFieldPublisherGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveRevokeAuthorizedFieldGrant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRevokeAuthorizedFieldGrantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRevokeAuthorizedFieldGrantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveRevokeAuthorizedFieldGrantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RevokeAuthorizedFieldGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RevokeAuthorizedFieldGrantReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RevokeAuthorizedFieldGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RevokeAuthorizedFieldGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RevokeAuthorizedFieldGrantResp and nil error while calling RevokeAuthorizedFieldGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveRevokeAuthorizedFieldGrantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RevokeAuthorizedFieldGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RevokeAuthorizedFieldGrantReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RevokeAuthorizedFieldGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RevokeAuthorizedFieldGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RevokeAuthorizedFieldGrantResp and nil error while calling RevokeAuthorizedFieldGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeletePublication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeletePublicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeletePublicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeletePublicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeletePublication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeletePublicationReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeletePublicationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeletePublication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeletePublicationResp and nil error while calling DeletePublication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeletePublicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeletePublication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeletePublicationReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeletePublicationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeletePublication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeletePublicationResp and nil error while calling DeletePublication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteIAMRolePublication(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteIAMRolePublicationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteIAMRolePublicationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteIAMRolePublicationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRolePublication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteIAMRolePublicationReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteIAMRolePublicationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteIAMRolePublication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteIAMRolePublicationResp and nil error while calling DeleteIAMRolePublication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteIAMRolePublicationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRolePublication")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteIAMRolePublicationReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteIAMRolePublicationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteIAMRolePublication(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteIAMRolePublicationResp and nil error while calling DeleteIAMRolePublication. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveListPublicationsByEventStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPublicationsByEventStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPublicationsByEventStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveListPublicationsByEventStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicationsByEventStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListPublicationsByEventStreamReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListPublicationsByEventStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListPublicationsByEventStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPublicationsByEventStreamResp and nil error while calling ListPublicationsByEventStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveListPublicationsByEventStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicationsByEventStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListPublicationsByEventStreamReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListPublicationsByEventStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListPublicationsByEventStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPublicationsByEventStreamResp and nil error while calling ListPublicationsByEventStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldGrant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAuthorizedFieldGrantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAuthorizedFieldGrantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldGrantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAuthorizedFieldGrantReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedFieldGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldGrantResp and nil error while calling DeleteAuthorizedFieldGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldGrantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteAuthorizedFieldGrantReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedFieldGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldGrantResp and nil error while calling DeleteAuthorizedFieldGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldSubscriberGrant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAuthorizedFieldSubscriberGrantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAuthorizedFieldSubscriberGrantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldSubscriberGrantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldSubscriberGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAuthorizedFieldSubscriberGrantReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldSubscriberGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedFieldSubscriberGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldSubscriberGrantResp and nil error while calling DeleteAuthorizedFieldSubscriberGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldSubscriberGrantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedFieldSubscriberGrant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteAuthorizedFieldSubscriberGrantReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldSubscriberGrantResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedFieldSubscriberGrant(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldSubscriberGrantResp and nil error while calling DeleteAuthorizedFieldSubscriberGrant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteEventType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEventTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEventTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteEventTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEventTypeReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEventTypeResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEventType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventTypeResp and nil error while calling DeleteEventType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteEventTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteEventTypeReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEventTypeResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEventType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventTypeResp and nil error while calling DeleteEventType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteEventStreamsForEventType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEventStreamsForEventTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEventStreamsForEventTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteEventStreamsForEventTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventStreamsForEventType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEventStreamsForEventTypeReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEventStreamsForEventTypeResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEventStreamsForEventType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventStreamsForEventTypeResp and nil error while calling DeleteEventStreamsForEventType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteEventStreamsForEventTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEventStreamsForEventType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteEventStreamsForEventTypeReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEventStreamsForEventTypeResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEventStreamsForEventType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEventStreamsForEventTypeResp and nil error while calling DeleteEventStreamsForEventType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedField(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAuthorizedFieldJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAuthorizedFieldProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedField")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAuthorizedFieldReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedField(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldResp and nil error while calling DeleteAuthorizedField. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveDeleteAuthorizedFieldProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAuthorizedField")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteAuthorizedFieldReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteAuthorizedFieldResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteAuthorizedField(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAuthorizedFieldResp and nil error while calling DeleteAuthorizedField. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAuthorizedFieldSubscriberGrantsByAuthorizedFieldJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAuthorizedFieldSubscriberGrantsByAuthorizedFieldProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *infrastructureServer) serveListAuthorizedFieldSubscriberGrantsByAuthorizedFieldJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAuthorizedFieldSubscriberGrantsByAuthorizedField")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp and nil error while calling ListAuthorizedFieldSubscriberGrantsByAuthorizedField. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) serveListAuthorizedFieldSubscriberGrantsByAuthorizedFieldProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAuthorizedFieldSubscriberGrantsByAuthorizedField")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAuthorizedFieldSubscriberGrantsByAuthorizedField(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp and nil error while calling ListAuthorizedFieldSubscriberGrantsByAuthorizedField. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *infrastructureServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *infrastructureServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1554 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0xcd, 0x6f, 0xdc, 0x44,
	0x14, 0xef, 0xec, 0xe6, 0xf3, 0x6d, 0x4a, 0x36, 0xd3, 0x50, 0x5c, 0xb7, 0x09, 0x5b, 0x17, 0xb5,
	0x29, 0x45, 0x1b, 0x48, 0x8a, 0x40, 0x5c, 0x20, 0x69, 0xfa, 0xb1, 0x25, 0xad, 0x8a, 0x53, 0x0a,
	0x82, 0x22, 0xcb, 0xb1, 0x27, 0x89, 0xa9, 0xd7, 0x9e, 0xce, 0x78, 0x53, 0x05, 0x0e, 0xf4, 0xc0,
	0x01, 0x2e, 0x7c, 0xa8, 0x1c, 0xb8, 0x70, 0x43, 0xe2, 0x08, 0x27, 0xc4, 0x05, 0xf5, 0xc4, 0x05,
	0x21, 0x24, 0xfe, 0x06, 0xc4, 0x89, 0x3b, 0x67, 0xe4, 0xf1, 0xc7, 0x7a, 0xbd, 0xbb, 0xce, 0xe2,
	0x78, 0x91, 0x8a, 0x38, 0xfa, 0xcd, 0x9b, 0xf7, 0x7e, 0xf3, 0xbe, 0x66, 0xde, 0x33, 0xac, 0x1b,
	0xae, 0x49, 0xea, 0xef, 0xb6, 0xb8, 0x67, 0x39, 0x75, 0x6f, 0x77, 0x91, 0xec, 0x12, 0xc7, 0xdb,
	0x6c, 0xf1, 0x45, 0xc3, 0x75, 0x3c, 0xe6, 0xda, 0xd4, 0xd6, 0x1d, 0xb2, 0x68, 0x39, 0x5b, 0x4c,
	0xe7, 0x1e, 0x6b, 0x19, 0x5e, 0x8b, 0x91, 0x45, 0x46, 0x8d, 0x14, 0xa9, 0x4e, 0x99, 0xeb, 0xb9,
	0x78, 0xb9, 0x53, 0x5a, 0x3d, 0x92, 0x56, 0x4f, 0x4a, 0xab, 0x77, 0x6e, 0x55, 0x3e, 0x2f, 0xc3,
	0xf4, 0x45, 0x9f, 0x71, 0x8d, 0x6c, 0x59, 0x8e, 0xe5, 0x59, 0xae, 0x83, 0xe7, 0x00, 0xc4, 0x5e,
	0xcd, 0xdb, 0xa3, 0x44, 0x42, 0x35, 0xb4, 0x30, 0xa9, 0x4e, 0x0a, 0xca, 0xcd, 0x3d, 0x4a, 0xf0,
	0x49, 0x98, 0x32, 0x2d, 0x4e, 0x6d, 0x7d, 0x4f, 0x73, 0xf4, 0x26, 0x91, 0xca, 0x82, 0xa1, 0x12,
	0xd2, 0xae, 0xeb, 0x4d, 0x82, 0xcf, 0xc1, 0x0c, 0xdf, 0x71, 0x99, 0xa7, 0x99, 0x84, 0x1b, 0xcc,
	0xa2, 0xbe, 0x58, 0x69, 0x44, 0xf0, 0x55, 0xc5, 0xc2, 0x5a, 0x9b, 0x8e, 0x6b, 0x50, 0x49, 0xb2,
	0x8d, 0x85, 0xe2, 0x12, 0x1c, 0x47, 0x61, 0x8c, 0x1b, 0x3b, 0xa4, 0xa9, 0x4b, 0x13, 0x62, 0x31,
	0xfc, 0xc2, 0xa7, 0xe0, 0x30, 0x23, 0xd4, 0xd5, 0xb6, 0x2c, 0x9b, 0x50, 0xdd, 0xdb, 0x91, 0x26,
	0xc5, 0xf2, 0x94, 0x4f, 0xbc, 0x14, 0xd2, 0xf0, 0x3c, 0x80, 0x49, 0x28, 0x23, 0x86, 0xee, 0x11,
	0x53, 0xaa, 0xd4, 0xd0, 0xc2, 0x84, 0x9a, 0xa0, 0xe0, 0xbb, 0x30, 0xa3, 0xb7, 0xbc, 0x1d, 0x97,
	0x59, 0xef, 0x11, 0x53, 0xdb, 0xb2, 0x88, 0x6d, 0x72, 0x09, 0x6a, 0xe5, 0x85, 0xca, 0xd2, 0x5a,
	0x3d, 0x87, 0x49, 0xeb, 0x2b, 0xb1, 0xb4, 0x4b, 0xbe, 0x30, 0xb5, 0xaa, 0x77, 0x12, 0xb8, 0x6f,
	0x60, 0xdb, 0xd4, 0xa9, 0xb6, 0xcd, 0xdc, 0x16, 0x95, 0xa6, 0x02, 0x03, 0xfb, 0x94, 0xcb, 0x3e,
	0x41, 0xf9, 0x0c, 0xc1, 0x71, 0x95, 0x6c, 0x5b, 0xdc, 0x23, 0x2c, 0xe5, 0x1b, 0xae, 0x92, 0xbb,
	0x3e, 0xe2, 0xc0, 0x3f, 0x66, 0x9b, 0x2e, 0xa1, 0x03, 0x20, 0x4e, 0x29, 0x51, 0xab, 0x24, 0xa5,
	0x55, 0x79, 0x50, 0x82, 0x13, 0xfd, 0x21, 0x71, 0x8a, 0x19, 0x8c, 0x33, 0xc2, 0x5b, 0xb6, 0x17,
	0x21, 0x79, 0x33, 0x17, 0x92, 0x2c, 0x1d, 0x75, 0x55, 0x28, 0x50, 0x23, 0x45, 0xf2, 0x07, 0x30,
	0x16, 0x90, 0xb0, 0x04, 0xe3, 0x06, 0x23, 0xc2, 0xc1, 0x48, 0x38, 0x38, 0xfa, 0xc4, 0x32, 0x4c,
	0x34, 0x09, 0xe7, 0xfa, 0x36, 0xe1, 0x52, 0xa9, 0x56, 0x5e, 0x98, 0x54, 0xe3, 0xef, 0x54, 0x9c,
	0x97, 0xd3, 0x71, 0x5e, 0x83, 0x0a, 0x71, 0x76, 0x2d, 0xe6, 0x3a, 0x4d, 0xe2, 0x78, 0x61, 0xf8,
	0x26, 0x49, 0xca, 0x37, 0x08, 0x9e, 0x58, 0xb1, 0x6d, 0xf7, 0xde, 0x8a, 0x61, 0xb8, 0x2d, 0xc7,
	0xe3, 0x37, 0x5a, 0x9b, 0xb6, 0xc5, 0x77, 0x7c, 0x27, 0xed, 0x93, 0x44, 0x73, 0x00, 0x9c, 0xb0,
	0x5d, 0xcb, 0x20, 0x9a, 0x65, 0x4a, 0xa5, 0x60, 0x39, 0xa4, 0x34, 0xcc, 0xfd, 0x75, 0xe3, 0xd3,
	0x30, 0xad, 0xdf, 0xe3, 0x9a, 0x1e, 0x68, 0xd6, 0x2c, 0x93, 0x4b, 0xa3, 0xe2, 0x7c, 0x87, 0xf5,
	0x7b, 0x3c, 0xc4, 0xd3, 0x30, 0xf9, 0xd5, 0x91, 0x89, 0x72, 0x75, 0x44, 0x79, 0x16, 0xa4, 0xde,
	0x40, 0x39, 0xc5, 0xb3, 0x30, 0xaa, 0x9b, 0x66, 0x6c, 0xba, 0xe0, 0x43, 0xf1, 0xe0, 0xa8, 0xd8,
	0xd1, 0x58, 0xb9, 0xa6, 0xba, 0x36, 0x19, 0xfc, 0x64, 0x29, 0xe8, 0xa5, 0x6e, 0xe8, 0xc7, 0x60,
	0xc2, 0xd2, 0x9b, 0x1a, 0x73, 0xed, 0xc8, 0xea, 0xe3, 0x96, 0xde, 0xf4, 0xb5, 0x28, 0xcb, 0xa1,
	0x41, 0xd3, 0x5a, 0x39, 0xed, 0xef, 0x63, 0x65, 0x17, 0x66, 0xd7, 0x88, 0x4d, 0xbc, 0x80, 0xdd,
	0xd0, 0x45, 0x0c, 0x17, 0x01, 0xb4, 0xd3, 0x49, 0xe5, 0x94, 0x93, 0x94, 0xe7, 0xe0, 0xf1, 0x1e,
	0x7a, 0x03, 0xa8, 0xa6, 0x58, 0x88, 0xa1, 0x86, 0x9f, 0xca, 0x7d, 0x04, 0xc7, 0x83, 0x3d, 0xc9,
	0x13, 0x16, 0x08, 0xb9, 0x06, 0x53, 0x91, 0x6d, 0x35, 0x9d, 0x39, 0x21, 0x68, 0x08, 0xed, 0xbb,
	0xc2, 0x1c, 0x65, 0x1e, 0x4e, 0xf4, 0x47, 0xc0, 0xa9, 0x62, 0x40, 0x6d, 0xdd, 0xe2, 0x5e, 0x82,
	0xcc, 0x57, 0xf7, 0x44, 0x3e, 0x6e, 0x78, 0x8c, 0xe8, 0xcd, 0x22, 0x60, 0x2a, 0x1f, 0x23, 0x38,
	0xb9, 0x8f, 0x16, 0x4e, 0xb1, 0x09, 0x53, 0x34, 0xc1, 0x10, 0x56, 0x96, 0x57, 0x72, 0x55, 0x96,
	0xe4, 0x31, 0x3b, 0xa4, 0x2a, 0x7f, 0x21, 0x38, 0x73, 0x41, 0x84, 0x52, 0xaa, 0x72, 0x6f, 0xb4,
	0x36, 0xfd, 0x3b, 0x68, 0x93, 0xb0, 0xcb, 0x4c, 0x77, 0xbc, 0x42, 0xfc, 0xe3, 0x42, 0x35, 0x7d,
	0xdb, 0x08, 0x1f, 0x15, 0x75, 0xd9, 0x4c, 0xa7, 0x2e, 0x9b, 0x8e, 0x64, 0x1b, 0xe9, 0x4c, 0xb6,
	0xa7, 0x61, 0x61, 0xb0, 0x73, 0x73, 0xaa, 0x7c, 0x88, 0xe0, 0x74, 0x4f, 0xe6, 0x30, 0x45, 0x8b,
	0xb4, 0x51, 0x46, 0x7d, 0x38, 0xdb, 0xc7, 0x55, 0x69, 0x14, 0x9c, 0x2a, 0x1b, 0x30, 0x9d, 0x62,
	0xf2, 0x5f, 0x2e, 0x61, 0xf1, 0x0f, 0x5e, 0x2e, 0x01, 0xb6, 0x4a, 0x48, 0x13, 0x2f, 0x97, 0x39,
	0x00, 0xe1, 0x94, 0x80, 0x21, 0xac, 0xcb, 0x82, 0xe2, 0x2f, 0x2b, 0x5f, 0x95, 0x60, 0x4e, 0x25,
	0xbb, 0xee, 0x9d, 0x34, 0x80, 0xf8, 0xf4, 0x0c, 0x26, 0x69, 0x04, 0x46, 0x28, 0xa8, 0x2c, 0xa9,
	0x45, 0x78, 0xb6, 0xf3, 0x84, 0x57, 0x0e, 0xa9, 0x6d, 0x35, 0xb8, 0x05, 0xc0, 0x63, 0x9f, 0x09,
	0xd0, 0x95, 0xa5, 0x8d, 0x22, 0x94, 0xa6, 0x22, 0xe1, 0xca, 0x21, 0x35, 0xa1, 0x68, 0x75, 0x06,
	0xa6, 0x19, 0xd9, 0x75, 0x83, 0x3c, 0x12, 0xde, 0x56, 0x5e, 0x82, 0xf9, 0x2c, 0xf3, 0x04, 0xb5,
	0x91, 0x09, 0x8e, 0xb8, 0x36, 0x86, 0x9f, 0xca, 0x9f, 0x08, 0x5e, 0xf0, 0x6b, 0x42, 0x36, 0x06,
	0xbe, 0xba, 0x97, 0x8e, 0xf9, 0x47, 0x31, 0x2f, 0x95, 0x1f, 0x11, 0xbc, 0x98, 0xef, 0xb4, 0x9c,
	0xe2, 0xfb, 0x08, 0x66, 0xda, 0x8e, 0xd0, 0xb6, 0x05, 0x6b, 0x58, 0x1e, 0x87, 0xe1, 0x78, 0xb5,
	0xca, 0x53, 0xb8, 0xfc, 0x17, 0xe1, 0x5c, 0x70, 0x8f, 0xfc, 0x9f, 0x09, 0xab, 0xe3, 0x30, 0x2a,
	0x7c, 0xe0, 0xc7, 0x7f, 0x96, 0x51, 0x32, 0xdf, 0x06, 0x5f, 0x20, 0x38, 0xd3, 0x73, 0x73, 0x8f,
	0x7b, 0xc8, 0x0a, 0x15, 0x86, 0x76, 0x1d, 0x8a, 0xcf, 0xc3, 0x23, 0xad, 0xc1, 0xc2, 0x60, 0xa8,
	0x32, 0x0f, 0xb7, 0x0c, 0x38, 0x90, 0x72, 0x31, 0x4a, 0xca, 0xfd, 0xd3, 0x56, 0x59, 0x84, 0x23,
	0x5d, 0x9b, 0x32, 0xb5, 0xac, 0xc2, 0xc9, 0xc4, 0x86, 0xe0, 0x25, 0xc1, 0x2f, 0xb9, 0xec, 0x9f,
	0x28, 0xd5, 0x40, 0xd9, 0x4f, 0x46, 0x16, 0x06, 0xfc, 0x24, 0x54, 0x9c, 0x56, 0x53, 0x8b, 0x56,
	0xfd, 0x18, 0x1c, 0x55, 0xc1, 0x69, 0x35, 0xd7, 0x42, 0x90, 0xbf, 0x20, 0x90, 0x7a, 0x5a, 0xf4,
	0xd1, 0x2c, 0x64, 0xcf, 0xc3, 0xb1, 0x3e, 0xa7, 0xc9, 0x74, 0xd5, 0xfb, 0x30, 0x97, 0x99, 0xd7,
	0x43, 0x7d, 0x46, 0x7c, 0x5a, 0x82, 0xf9, 0xec, 0x70, 0xfe, 0x4f, 0xbd, 0xf4, 0xfc, 0xae, 0xe0,
	0x4e, 0x93, 0x07, 0xf7, 0x84, 0xdf, 0xca, 0x8c, 0x06, 0x5d, 0xc1, 0x9d, 0x26, 0x17, 0x87, 0x6d,
	0x98, 0xca, 0x27, 0x65, 0xa8, 0x24, 0x9e, 0xc8, 0x07, 0x3f, 0xbe, 0x02, 0x87, 0xb9, 0xc3, 0x35,
	0xcf, 0xa5, 0x96, 0x91, 0xe8, 0x44, 0x2a, 0xdc, 0xe1, 0x37, 0x7d, 0xda, 0x0a, 0x73, 0xf0, 0xb9,
	0xf6, 0x20, 0xa3, 0x6b, 0x4c, 0x14, 0x8e, 0x20, 0xda, 0x43, 0xa0, 0xb3, 0x50, 0x8d, 0x98, 0xe3,
	0x69, 0xce, 0xa8, 0x88, 0xa9, 0xe9, 0x90, 0x37, 0x1e, 0xe9, 0x3c, 0x03, 0x38, 0xbe, 0x12, 0xb4,
	0xd8, 0x26, 0xc1, 0x60, 0xa9, 0x1a, 0xaf, 0x34, 0x42, 0xe3, 0x9c, 0x87, 0xa3, 0x6d, 0xee, 0xa8,
	0xdf, 0x13, 0xcf, 0xbf, 0x71, 0xb1, 0x63, 0x36, 0x5e, 0xdd, 0x08, 0x16, 0xc5, 0x43, 0xf1, 0x65,
	0x38, 0xd1, 0xbd, 0xcb, 0xd0, 0x3d, 0xdd, 0x76, 0xb7, 0x7d, 0x13, 0x07, 0x93, 0xaa, 0x63, 0xe9,
	0xbd, 0x17, 0x02, 0x8e, 0x86, 0x99, 0x6a, 0x2e, 0x27, 0x53, 0xcd, 0xe5, 0xd2, 0x97, 0x12, 0x3c,
	0xd6, 0xe8, 0x88, 0x00, 0xfc, 0x03, 0x82, 0xd9, 0x5e, 0x5d, 0x3c, 0x5e, 0xcf, 0x17, 0x50, 0xbd,
	0x27, 0x17, 0xf2, 0xb5, 0x02, 0xa5, 0x71, 0xaa, 0x94, 0x3f, 0x2a, 0x21, 0xfc, 0x1d, 0x82, 0x23,
	0x3d, 0x1a, 0x7b, 0xfc, 0x6a, 0x7e, 0x5d, 0x5d, 0x83, 0x09, 0x79, 0xbd, 0x38, 0x61, 0x9c, 0xe2,
	0x87, 0x08, 0xa4, 0x7e, 0xe3, 0x28, 0x7c, 0xa3, 0xe0, 0xe9, 0xd6, 0x5d, 0xf9, 0xb5, 0xc2, 0xe7,
	0x65, 0xf8, 0x77, 0x04, 0x4f, 0x0d, 0xd2, 0xe0, 0xe1, 0xdb, 0xb9, 0x74, 0x0f, 0xd8, 0x33, 0xcb,
	0xef, 0x0c, 0x51, 0x3a, 0xa7, 0xf8, 0x0f, 0x04, 0xa7, 0x06, 0xe8, 0x09, 0xf1, 0xdb, 0xc5, 0xc1,
	0xe8, 0xea, 0x79, 0xe5, 0xdb, 0xc3, 0x13, 0x1e, 0xa5, 0xd0, 0x4f, 0x08, 0xe4, 0xfe, 0xbd, 0x15,
	0x56, 0x73, 0xc6, 0x4f, 0x46, 0x2f, 0x2b, 0x6f, 0x14, 0x2e, 0x93, 0x53, 0xfc, 0x2d, 0x82, 0x99,
	0xae, 0xb1, 0x19, 0x6e, 0xe4, 0x52, 0xd5, 0x6b, 0xec, 0x27, 0x5f, 0x2d, 0x4a, 0x54, 0x64, 0xf9,
	0x87, 0xf1, 0x83, 0xad, 0x7b, 0x64, 0x96, 0xb3, 0x12, 0x64, 0xcc, 0x00, 0x73, 0x56, 0x82, 0xac,
	0x99, 0x1e, 0xfe, 0x15, 0xc1, 0x5c, 0xe6, 0xb8, 0x0d, 0xbf, 0x9e, 0x4b, 0xe9, 0x7e, 0x83, 0x42,
	0xf9, 0xd6, 0x30, 0xc4, 0x72, 0x8a, 0x7f, 0x46, 0x20, 0xf7, 0x6f, 0xb4, 0x72, 0x26, 0x43, 0x66,
	0x3b, 0x9b, 0x33, 0x19, 0xb2, 0xbb, 0xc1, 0x20, 0xbe, 0xfc, 0x3a, 0x3d, 0x48, 0x8b, 0x95, 0xb3,
	0x4e, 0x0f, 0xd8, 0x53, 0xe6, 0xac, 0xd3, 0x03, 0xf7, 0x86, 0x5f, 0x23, 0x98, 0x4e, 0x75, 0x73,
	0xf8, 0xf2, 0x01, 0x54, 0x26, 0x7b, 0x3a, 0xf9, 0x4a, 0x31, 0x82, 0x38, 0xc5, 0xbf, 0xa1, 0xa8,
	0x85, 0xef, 0xd7, 0xff, 0xe1, 0x5b, 0x07, 0x55, 0xd6, 0xbb, 0x31, 0x95, 0xdf, 0x18, 0x8a, 0x5c,
	0x4e, 0xf1, 0xf7, 0x28, 0xfa, 0x53, 0x91, 0x9e, 0x88, 0x5e, 0x2b, 0xce, 0xe7, 0xfe, 0x09, 0xae,
	0x17, 0x29, 0x8e, 0x53, 0xfc, 0xa0, 0x04, 0xe7, 0xf3, 0x0c, 0xc9, 0xb0, 0x9d, 0xbb, 0xee, 0xe4,
	0x98, 0x3e, 0xca, 0xcd, 0x7f, 0x51, 0x1b, 0xa7, 0xab, 0xa3, 0x6f, 0x95, 0x19, 0x35, 0x36, 0xc7,
	0xc4, 0x6f, 0xff, 0xe5, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xf6, 0xc9, 0x8f, 0xbf, 0x46, 0x20,
	0x00, 0x00,
}
