package validation

import "time"

type Report struct {
	Item      Item
	Message   string
	Status    Status
	Timestamp time.Time
}

// NotOk will return all reports in the list provided that are not of status OK.
// If every report is of status OK, nil will be returned
func NotOk(reports []*Report) []*Report {
	var notOk []*Report
	for _, report := range reports {
		if report.Status != StatusOk {
			notOk = append(notOk, report)
		}
	}
	return notOk
}

func Ok(item Item) *Report {
	return report(item, "", StatusOk)
}

func Warn(item Item, msg string) *Report {
	return report(item, msg, StatusWarn)
}

func Error(item Item, msg string) *Report {
	return report(item, msg, StatusError)
}

func ValidationError(item Item, msg string) *Report {
	return report(item, msg, StatusValidationError)
}

func report(item Item, msg string, status Status) *Report {
	return &Report{
		item,
		msg,
		status,
		time.Now(),
	}
}
