package arn

import (
	"fmt"

	awsarn "github.com/aws/aws-sdk-go/aws/arn"
)

func AssumeRoleARN(accountID string, env string) string {
	if env == "production" || env == "prod" {
		return fmt.Sprintf(`arn:aws:iam::%s:role/EventBus/EventBus`, accountID)
	}
	return fmt.Sprintf(`arn:aws:iam::%s:role/EventBus-%s/EventBus-%s`, accountID, env, env)
}

func AccountID(arn string) (string, error) {
	a, err := awsarn.Parse(arn)
	if err != nil {
		return "", err
	}
	return a.AccountID, nil
}

func IAMRootARN(accountID string) string {
	return fmt.Sprintf("arn:aws:iam::%v:root", accountID)
}
