package arn

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestAssumeRoleArn(t *testing.T) {
	t.Run("AssumeRoleARN", func(t *testing.T) {
		t.Run("works for production", func(t *testing.T) {
			env := "production"
			accountID := "1234"
			arn := AssumeRoleARN(accountID, env)
			assert.Equal(t, arn, "arn:aws:iam::1234:role/EventBus/EventBus")
		})

		t.Run("works for prod", func(t *testing.T) {
			env := "prod"
			accountID := "1234"
			arn := AssumeRoleARN(accountID, env)
			assert.Equal(t, arn, "arn:aws:iam::1234:role/EventBus/EventBus")
		})

		t.Run("works for staging", func(t *testing.T) {
			env := "staging"
			accountID := "1234"
			arn := AssumeRoleARN(accountID, env)
			assert.Equal(t, arn, "arn:aws:iam::1234:role/EventBus-staging/EventBus-staging")
		})
	})
}
