package auditlog

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"

	"github.com/jmoiron/sqlx"
)

func (b BaseLog) LogServiceCreate(ctx context.Context, err error, after *db.Service) {
	b.log(ctx, err, ResourceService, APICreate, after)
}

// Accounts, services, and IAM roles are modified in transactions which may also modify other accounts, IAM roles, or the corresponding service.
func (b BaseLog) LogServiceUpdate(ctx context.Context, tx *sqlx.Tx, err error, before *db.Service, after *db.ServiceEditable) {
	e := before.Editable()
	b.logTx(ctx, tx, err, ResourceService, APIUpdate, e, after)
}

func (b BaseLog) LogIAMRoleCreate(ctx context.Context, err error, after *db.IAMRole) {
	b.log(ctx, err, ResourceIAMRole, APICreate, after)
}

func (b BaseLog) LogIAMRoleCreateTx(ctx context.Context, tx *sqlx.Tx, err error, after *db.IAMRole) {
	b.logTx(ctx, tx, err, ResourceIAMRole, APICreate, nil, after)
}

func (b BaseLog) LogIAMRoleUpdate(ctx context.Context, tx *sqlx.Tx, err error, before *db.IAMRole, after *db.IAMRoleEditable) {
	e := before.Editable()
	b.logTx(ctx, tx, err, ResourceIAMRole, APIUpdate, e, after)
}

func (b BaseLog) LogIAMRoleDelete(ctx context.Context, err error) {
	b.log(ctx, err, ResourceIAMRole, APIDelete, nil)
}

func (b BaseLog) LogAccountCreate(ctx context.Context, tx *sqlx.Tx, err error, after *db.Account) {
	b.logTx(ctx, tx, err, ResourceAccount, APICreate, nil, after)
}

func (b BaseLog) LogAccountUpdate(ctx context.Context, tx *sqlx.Tx, err error, before *db.Account, after *db.AccountEditable) {
	e := before.Editable()
	b.logTx(ctx, tx, err, ResourceAccount, APIUpdate, e, after)
}

func (b BaseLog) LogAccountDelete(ctx context.Context, err error) {
	b.log(ctx, err, ResourceAccount, APIDelete, nil)
}

func (b BaseLog) LogSubscriptionTargetCreate(ctx context.Context, err error, after *db.SubscriptionTarget) {
	b.log(ctx, err, ResourceSubscriptionTarget, APICreate, after)
}

func (b BaseLog) LogSubscriptionTargetDelete(ctx context.Context, err error) {
	b.log(ctx, err, ResourceSubscriptionTarget, APIDelete, nil)
}

func (b BaseLog) LogSubscriptionCreate(ctx context.Context, err error, after *db.Subscription) {
	b.log(ctx, err, ResourceSubscription, APICreate, after)
}

func (b BaseLog) LogSubscriptionDelete(ctx context.Context, err error) {
	b.log(ctx, err, ResourceSubscription, APIDelete, nil)
}
