//go:generate eventbus-mockery -dir . -output ../mocks -case snake -name "KMSAPI"

package kms

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kms"
)

// KMSAPI is a much smaller subset of the KMS actions we actually use.
type KMSAPI interface {
	GetKeyPolicyWithContext(ctx aws.Context, input *kms.GetKeyPolicyInput, opts ...request.Option) (*kms.GetKeyPolicyOutput, error)
	PutKeyPolicyWithContext(ctx aws.Context, input *kms.PutKeyPolicyInput, opts ...request.Option) (*kms.PutKeyPolicyOutput, error)
	DescribeKeyWithContext(ctx aws.Context, input *kms.DescribeKeyInput, opts ...request.Option) (*kms.DescribeKeyOutput, error)
	CreateGrantWithContext(aws.Context, *kms.CreateGrantInput, ...request.Option) (*kms.CreateGrantOutput, error)
	RevokeGrantWithContext(aws.Context, *kms.RevokeGrantInput, ...request.Option) (*kms.RevokeGrantOutput, error)
	ListGrantsPagesWithContext(aws.Context, *kms.ListGrantsInput, func(*kms.ListGrantsResponse, bool) bool, ...request.Option) error
}

// This asserts that the real KMS client is a valid KMSAPI,
// It causes compile-time stubs to be generated in the bytecode which could speed up runtime.
var _ KMSAPI = (*kms.KMS)(nil)
