package ldap

import (
	"testing"

	"code.justin.tv/eventbus/controlplane/internal/clients/mocks"
	"github.com/go-ldap/ldap"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
)

func TestLDAPClient(t *testing.T) {
	mockLDAP := &mocks.LDAPSearcher{}

	mockLDAP.On("Search", mock.Anything, mock.Anything).Return(&ldap.SearchResult{
		Entries: []*ldap.Entry{
			{
				Attributes: []*ldap.EntryAttribute{
					{
						Values: []string{"Jimmy McNulty"},
					},
					{
						Values: []string{"jmcnulty"},
					},
				},
			},
			{
				Attributes: []*ldap.EntryAttribute{
					{
						Values: []string{"Bunk Moreland"},
					},
					{
						Values: []string{"bmoreland"},
					},
				},
			},
		},
	}, nil)

	ldapClient := &Client{
		ldapSearcher: mockLDAP,
	}

	users, err := ldapClient.UsersInGroup("team-coolcats")
	require.NoError(t, err)
	require.Len(t, users, 2)
	assert.Equal(t, "Jimmy McNulty", users[0].CN)
	assert.Equal(t, "jmcnulty", users[0].UID)
	assert.Equal(t, "Bunk Moreland", users[1].CN)
	assert.Equal(t, "bmoreland", users[1].UID)
}
