package servicecatalog

import (
	"fmt"
	"math/rand"
	"time"
)

func init() {
	rand.Seed(time.Now().Unix())
}

func FormatURL(id string) string {
	return fmt.Sprintf("https://catalog.xarth.tv/services/%s/details", id)
}

func generateLocalServiceData() *Response {
	adjectives := []string{"fierce", "poetic", "tranquil", "fearsome", "malevolent", "benevolent", "sleepy", "lovestruck", "gargantuan", "seismic"}
	animals := []string{"badger", "porcupine", "lion", "eagle", "panther", "sheep", "crocodile", "python", "wolf", "bear"}
	randomService := fmt.Sprintf("%s-%s", adjectives[rand.Intn(len(adjectives))], animals[rand.Intn(len(animals))])
	return &Response{
		Name:        randomService,
		Description: fmt.Sprintf("Local Test with Service %s", randomService),
		Slack:       "#slack",
		Pagerduty:   "link/to/pagerduty",
	}
}
