package slack

import (
	"context"

	slackapi "github.com/nlopes/slack"
	"github.com/pkg/errors"
)

func (s *slack) SendMessage(ctx context.Context, text string, attachments ...slackapi.Attachment) error {
	attachmentOpt := slackapi.MsgOptionAttachments(attachments...)
	_, _, err := s.client.PostMessageContext(ctx, s.channel, slackapi.MsgOptionText(text, false), attachmentOpt)
	return errors.Wrap(err, "failed to post message")
}
