package slack

import (
	"context"

	slackapi "github.com/nlopes/slack"
	"github.com/pkg/errors"
)

type Slack interface {
	SendMessage(ctx context.Context, text string, attachments ...slackapi.Attachment) error
}

type Config struct {
	Token   string
	Channel string
}

type slack struct {
	client  *slackapi.Client
	channel string
}

func New(config *Config) (Slack, error) {
	if config.Token == "" {
		return nil, errors.New("slack token is empty")
	} else if config.Channel == "" {
		return nil, errors.New("slack channel is empty")
	}

	client := slackapi.New(config.Token)

	if _, err := client.AuthTest(); err != nil {
		return nil, errors.Wrap(err, "failed auth test")
	}

	return &slack{
		client:  client,
		channel: config.Channel,
	}, nil
}
