package containers

import (
	"strings"
)

type StringArray []string

func (s *StringArray) Remove(query string) {
	for i, item := range *s {
		if item == query {
			ss := *s
			*s = append(ss[:i], ss[i+1:]...)
			return
		}
	}
}

func (s StringArray) Contains(query string) bool {
	for _, item := range s {
		if item == query {
			return true
		}
	}
	return false
}

func (s StringArray) ContainsEqualFold(query string) bool {
	for _, item := range s {
		if strings.EqualFold(item, query) {
			return true
		}
	}
	return false
}

func (s StringArray) Clone() StringArray {
	dst := make(StringArray, len(s))
	copy(dst, s)
	return dst
}
