package containers

type StringSet map[string]bool

func (ss StringSet) Add(value string) {
	ss[value] = true
}

func (ss StringSet) Remove(value string) {
	delete(ss, value)
}

func (ss StringSet) StringArray() []string {
	output := make([]string, 0, len(ss))
	for value := range ss {
		output = append(output, value)
	}
	return output
}

func StringSetFromArray(input []string) StringSet {
	output := make(StringSet, len(input))
	for _, value := range input {
		output[value] = true
	}
	return output
}
