package db

import (
	"context"
	"time"

	"github.com/jmoiron/sqlx/types"

	"github.com/jmoiron/sqlx"
	"go.uber.org/zap/zapcore"
)

type AuditLog struct {
	ID           int            `json:"id" db:"id"`
	UserName     string         `json:"user_name" db:"user_name"`
	ServiceID    int            `json:"service_id" db:"service_id"`
	ResourceName string         `json:"resource_name" db:"resource_name"`
	ResourceType string         `json:"resource_type" db:"resource_type"`
	Result       string         `json:"result" db:"result"`
	Action       string         `json:"action" db:"action"`
	Timestamp    time.Time      `json:"timestamp" db:"timestamp"`
	Before       types.JSONText `json:"before" db:"before"`
	After        types.JSONText `json:"after" db:"after"`
}

func (al AuditLog) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt("id", al.ID)
	enc.AddString("userName", al.UserName)
	enc.AddInt("serviceID", al.ServiceID)
	enc.AddString("ResourceName", al.ResourceName)
	enc.AddString("ResourceType", al.ResourceType)
	enc.AddString("Result", al.Result)
	enc.AddString("Action", al.Action)
	enc.AddTime("Timestamp", al.Timestamp)
	enc.AddString("Before", al.Before.String())
	enc.AddString("After", al.After.String())
	return nil
}

type AuditLogsDB interface {
	AuditLogsByServiceID(ctx context.Context, serviceID int) ([]*AuditLog, error)
	AuditLogCreate(ctx context.Context, al *AuditLog) (int, error)
	AuditLogCreateTx(ctx context.Context, tx *sqlx.Tx, al *AuditLog) (int, error)
}
