package db

import (
	"context"
	"database/sql"
	"time"

	"go.uber.org/zap/zapcore"
)

type AuthorizedFieldPublisherGrant struct {
	ID            int           `json:"id" db:"id"`
	IAMRoleID     int           `json:"iam_role_id" db:"iam_role_id"`
	EventStreamID int           `json:"event_stream_id" db:"event_stream_id"`
	KMSGrantID    string        `json:"kms_grant_id" db:"kms_grant_id"`
	AWSLeaseID    sql.NullInt64 `json:"aws_lease_id" db:"aws_lease_id"`
}

func (a AuthorizedFieldPublisherGrant) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt("id", a.ID)
	enc.AddInt("eventStreamID", a.EventStreamID)
	enc.AddInt("iamRoleID", a.IAMRoleID)
	return nil
}

type AuthorizedFieldPublisherGrantInfraUpdate struct {
	KMSGrantID string
}

func (a AuthorizedFieldPublisherGrantInfraUpdate) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("kmsGrantID", a.KMSGrantID)
	return nil
}

type AuthorizedFieldPublisherGrantDB interface {
	AuthorizedFieldPublisherGrants(ctx context.Context) ([]*AuthorizedFieldPublisherGrant, error)
	AuthorizedFieldPublisherGrant(ctx context.Context, iamRoleID, eventStreamID int) (*AuthorizedFieldPublisherGrant, error)
	AuthorizedFieldPublisherGrantByID(ctx context.Context, id int) (*AuthorizedFieldPublisherGrant, error)
	AuthorizedFieldPublisherGrantsByIAMRoleID(ctx context.Context, iamRoleID int) ([]*AuthorizedFieldPublisherGrant, error)
	AuthorizedFieldPublisherGrantsByEventStreamID(ctx context.Context, serviceID int) ([]*AuthorizedFieldPublisherGrant, error)

	AuthorizedFieldPublisherGrantDeleteByID(ctx context.Context, id int) error

	AuthorizedFieldPublisherGrantCreate(ctx context.Context, grant *AuthorizedFieldPublisherGrant) (int, error)
	AuthorizedFieldPublisherGrantUpdateInfra(ctx context.Context, lease AWSLease, id int, grantUpdateInfra *AuthorizedFieldPublisherGrantInfraUpdate) (int, error)

	AuthorizedFieldPublisherGrantAcquireLease(ctx context.Context, resourceID int, timeout time.Duration) (AWSLease, context.Context, error)
	AuthorizedFieldPublisherGrantReleaseLease(lease AWSLease) error
}
