package db

import (
	"context"

	"go.uber.org/zap/zapcore"
)

type AuthorizedField struct {
	ID            int    `json:"id" db:"id"`
	EventStreamID int    `json:"event_stream_id" db:"event_stream_id"`
	MessageName   string `json:"message_name" db:"message_name"`
	FieldName     string `json:"field_name" db:"field_name"`
}

func (a AuthorizedField) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt("id", a.ID)
	enc.AddInt("eventStreamID", a.EventStreamID)
	enc.AddString("messageName", a.MessageName)
	enc.AddString("fieldName", a.FieldName)
	return nil
}

type AuthorizedFieldsDB interface {
	AuthorizedFieldCreate(ctx context.Context, authorizedField *AuthorizedField) (int, error)

	AuthorizedFields(ctx context.Context) ([]*AuthorizedField, error)
	AuthorizedFieldByAuthContext(ctx context.Context, eventStreamID int, messageName, fieldName string) (*AuthorizedField, error)
	AuthorizedFieldByID(ctx context.Context, id int) (*AuthorizedField, error)
	AuthorizedFieldsByEventStreamID(ctx context.Context, eventStreamID int) ([]*AuthorizedField, error)

	AuthorizedFieldDeleteByID(ctx context.Context, id int) error
}
