package db

import (
	"context"
	"errors"
)

var ErrNotSupported = errors.New("currently not supported")

type DB interface {
	ServicesDB
	AccountsDB
	AuthorizedFieldsDB
	AuthorizedFieldPublisherGrantDB
	AuthorizedFieldSubscriberGrantDB
	EventTypesDB
	EventStreamsDB
	IAMRolesDB
	PublicationsDB
	SubscriptionsDB
	SubscriptionTargetsDB
	FeatureFlagsDB
	AuditLogsDB

	// EventTypeAndStreamsCreate creates an event type, and one event stream per provided environment
	EventTypeAndStreamsCreate(ctx context.Context, eventType *EventType, environments []string) ([]*EventStream, error)

	// EventStreamPublisherAccounts returns the accounts permitted to publish to the given event stream
	EventStreamPublisherAccounts(ctx context.Context, eventStreamID int) ([]*Account, error)

	// EventStreamPublisherIAMRoles returns the IAM roles permitted to publish to the given event stream
	EventStreamPublisherIAMRoles(ctx context.Context, eventStreamID int) ([]*IAMRole, error)

	// PublisherServicesByEventStreamID returns the services which contain an account that has publishing permissions
	// to the event stream with the provided ID
	PublisherServicesByEventStreamID(ctx context.Context, eventStreamID int) ([]*Service, error)

	// ServicesByEventType returns the services which have any subscriptions to any event streams for the corresponding event type
	ServicesSubscribedToEventType(ctx context.Context, eventType string) ([]*Service, error)

	// More higher order DB operations go here
}

type ServiceEditReport struct {
	ServiceRowsUpdated bool
	IAMRolesEditReport *IAMRolesEditReport
}
