package db

import (
	"strconv"

	"github.com/pkg/errors"
)

// ErrResourceNotFound LEGACY: Keep our single error around for a while as we search out all the uses of this.
var ErrResourceNotFound error = &notFoundError{resourceType: "resource"}

func NewNotFoundError(resourceType string, id int) error {
	return &notFoundError{
		resourceType: resourceType,
		resourceID:   strconv.Itoa(id),
	}
}

// IsNotFoundError tells us if the error object is of the not found class of errors.
func IsNotFoundError(err error) bool {
	for err != nil {
		if _, ok := err.(*notFoundError); ok {
			return true
		}
		rootErr := errors.Cause(err)
		if err == rootErr {
			return false
		}
		err = rootErr
	}
	return false
}

type notFoundError struct {
	resourceType string
	resourceID   string
}

func (nfe *notFoundError) Error() string {
	if nfe.resourceID == "" {
		return nfe.resourceType + " not found"
	}
	return nfe.resourceType + "with ID " + nfe.resourceID + " not found"
}
