package db

import (
	"context"

	"go.uber.org/zap/zapcore"
)

type FeatureFlag struct {
	ID      int    `json:"id" db:"id"`
	Name    string `json:"name" db:"name"`
	Enabled bool   `json:"enabled" db:"enabled"`
}

func (ff FeatureFlag) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt("id", ff.ID)
	enc.AddString("name", ff.Name)
	enc.AddBool("enabled", ff.Enabled)
	return nil
}

type FeatureFlagsDB interface {
	FeatureFlagByName(ctx context.Context, name string) (*FeatureFlag, error)
	FeatureFlags(ctx context.Context) ([]*FeatureFlag, error)
	FeatureFlagCreate(ctx context.Context, ff *FeatureFlag) (int, error)
	FeatureFlagDelete(ctx context.Context, name string) error
	FeatureFlagEnable(ctx context.Context, name string) error
	FeatureFlagDisable(ctx context.Context, name string) error
}
