package db

import (
	"time"

	"github.com/pkg/errors"
	"go.uber.org/zap/zapcore"
)

var ErrLeaseUnavailable = errors.New("could not acquire lease")
var ErrLeaseExpired = errors.New("lease for resource has expired")

type AWSLease interface {
	Release() error

	Expires() time.Time
	Expired() bool

	String() string

	MarshalLogObject(zapcore.ObjectEncoder) error
}
