package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) AccountCreate(ctx context.Context, account *db.Account) (int, error) {
	var id int
	var err error
	o.observe(ctx, "AccountCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.AccountCreate(ctx, account)
			cpy := *account
			cpy.ID = id
			return []zap.Field{
				zap.Object("account", cpy),
			}, err
		},
	)
	return id, err
}

func (o *ObservabilityDB) AccountUpdate(ctx context.Context, id int, accountEditable *db.AccountEditable) (int, error) {
	var retID int
	var err error
	o.observe(ctx, "Accountupdate",
		func() ([]zap.Field, error) {
			retID, err = o.db.AccountUpdate(ctx, id, accountEditable)
			return []zap.Field{
				zap.Object("accountUpdate", accountEditable),
				zap.Int("accountID", retID),
			}, err
		},
	)
	return retID, err
}

func (o *ObservabilityDB) AccountUpdateCloudformationStatus(ctx context.Context, id int, cloudformationStatus string) (int, error) {
	var retID int
	var err error
	o.observe(ctx, "AccountUpdateCloudformationStatus",
		func() ([]zap.Field, error) {
			retID, err = o.db.AccountUpdateCloudformationStatus(ctx, id, cloudformationStatus)
			return []zap.Field{
				zap.String("cloudformationStatus", cloudformationStatus),
				zap.Int("accountID", retID),
			}, err
		},
	)
	return retID, err
}

func (o *ObservabilityDB) AccountDelete(ctx context.Context, id int) error {
	var err error
	o.observe(ctx, "AccountDelete",
		func() ([]zap.Field, error) {
			err = o.db.AccountDelete(ctx, id)
			return []zap.Field{
				zap.Int("accountID", id),
			}, err
		})
	return err
}

func (o *ObservabilityDB) Accounts(ctx context.Context) ([]*db.Account, error) {
	var err error
	var accts []*db.Account
	o.observe(ctx, "Accounts",
		func() ([]zap.Field, error) {
			accts, err = o.db.Accounts(ctx)
			return []zap.Field{}, err
		})
	return accts, err
}

func (o *ObservabilityDB) AccountByID(ctx context.Context, id int) (*db.Account, error) {
	var err error
	var acct *db.Account
	o.observe(ctx, "AccountByID",
		func() ([]zap.Field, error) {
			acct, err = o.db.AccountByID(ctx, id)
			return []zap.Field{
				zap.Int("accountID", id),
			}, err
		})
	return acct, err
}
func (o *ObservabilityDB) AccountsByServiceID(ctx context.Context, serviceID int) ([]*db.Account, error) {
	var err error
	var accts []*db.Account
	o.observe(ctx, "AccountsByServiceID",
		func() ([]zap.Field, error) {
			accts, err = o.db.AccountsByServiceID(ctx, serviceID)
			return []zap.Field{
				zap.Int("serviceID", serviceID),
			}, err
		})
	return accts, err
}

func (o *ObservabilityDB) AccountByServiceIDAndAWSAccount(ctx context.Context, serviceID int, awsAccount string) (*db.Account, error) {
	var err error
	var acct *db.Account
	o.observe(ctx, "AccountByServiceIDAndAWSAccount",
		func() ([]zap.Field, error) {
			acct, err = o.db.AccountByServiceIDAndAWSAccount(ctx, serviceID, awsAccount)
			return []zap.Field{
				zap.Int("serviceID", serviceID),
				zap.String("awsAccount", awsAccount),
			}, err
		})
	return acct, err
}
