package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"

	"github.com/jmoiron/sqlx"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) AuditLogsByServiceID(ctx context.Context, serviceID int) ([]*db.AuditLog, error) {
	var err error
	var al []*db.AuditLog
	o.observe(ctx, "AuditLogsByService",
		func() ([]zap.Field, error) {
			al, err = o.db.AuditLogsByServiceID(ctx, serviceID)
			return []zap.Field{
				zap.Int("serviceID", serviceID),
			}, err
		})
	return al, err
}

func (o *ObservabilityDB) AuditLogCreate(ctx context.Context, auditLog *db.AuditLog) (int, error) {
	var err error
	var id int
	o.observe(ctx, "AuditLogCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.AuditLogCreate(ctx, auditLog)
			cpy := *auditLog
			cpy.ID = id
			return []zap.Field{
				zap.Object("auditLog", cpy),
			}, err
		})
	return id, err
}

func (o *ObservabilityDB) AuditLogCreateTx(ctx context.Context, tx *sqlx.Tx, auditLog *db.AuditLog) (int, error) {
	var err error
	var id int
	o.observe(ctx, "AuditLogCreateTx",
		func() ([]zap.Field, error) {
			id, err = o.db.AuditLogCreate(ctx, auditLog)
			cpy := *auditLog
			cpy.ID = id
			return []zap.Field{
				zap.Object("auditLog", cpy),
			}, err
		})
	return id, err
}
