package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) AuthorizedFieldCreate(ctx context.Context, authorizedField *db.AuthorizedField) (int, error) {
	var err error
	var id int
	o.observe(ctx, "AuthorizedFieldCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.AuthorizedFieldCreate(ctx, authorizedField)
			cpy := *authorizedField
			cpy.ID = id
			return []zap.Field{
				zap.Object("authorizedField", cpy),
			}, err
		})
	return id, err
}

func (o *ObservabilityDB) AuthorizedFields(ctx context.Context) ([]*db.AuthorizedField, error) {
	var err error
	var authorizedFields []*db.AuthorizedField
	o.observe(ctx, "AuthorizedFields",
		func() ([]zap.Field, error) {
			authorizedFields, err = o.db.AuthorizedFields(ctx)
			return []zap.Field{}, err
		})
	return authorizedFields, err
}

func (o *ObservabilityDB) AuthorizedFieldByAuthContext(ctx context.Context, eventStreamID int, messageName, fieldName string) (*db.AuthorizedField, error) {
	var err error
	var authorizedField *db.AuthorizedField
	o.observe(ctx, "AuthorizedFieldByAuthContext",
		func() ([]zap.Field, error) {
			authorizedField, err = o.db.AuthorizedFieldByAuthContext(ctx, eventStreamID, messageName, fieldName)
			return []zap.Field{
				zap.Int("eventStreamID", eventStreamID),
				zap.String("messageName", messageName),
				zap.String("fieldName", fieldName),
			}, err
		})
	return authorizedField, err
}
func (o *ObservabilityDB) AuthorizedFieldByID(ctx context.Context, id int) (*db.AuthorizedField, error) {
	var err error
	var authorizedField *db.AuthorizedField
	o.observe(ctx, "AuthorizedFieldByID",
		func() ([]zap.Field, error) {
			authorizedField, err = o.db.AuthorizedFieldByID(ctx, id)
			return []zap.Field{
				zap.Int("authorizedFieldID", id),
			}, err
		})
	return authorizedField, err
}
func (o *ObservabilityDB) AuthorizedFieldsByEventStreamID(ctx context.Context, eventStreamID int) ([]*db.AuthorizedField, error) {
	var err error
	var authorizedFields []*db.AuthorizedField
	o.observe(ctx, "AuthorizedFieldsByEventStreamID",
		func() ([]zap.Field, error) {
			authorizedFields, err = o.db.AuthorizedFieldsByEventStreamID(ctx, eventStreamID)
			return []zap.Field{
				zap.Int("eventStreamID", eventStreamID),
			}, err
		})
	return authorizedFields, err
}

func (o *ObservabilityDB) AuthorizedFieldDeleteByID(ctx context.Context, id int) error {
	var err error
	o.observe(ctx, "AuthorizedFieldDeleteByID",
		func() ([]zap.Field, error) {
			err = o.db.AuthorizedFieldDeleteByID(ctx, id)
			return []zap.Field{
				zap.Int("id", id),
			}, err
		})
	return err
}
